h03676
s 00063/00000/00000
d D 1.1 84/12/20 17:12:25 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <sys/file.h>
#include <sys/types.h>
#include <carl/midi.h>

open_midi(dev, flags)
	char *dev;
	int flags;
{
	int fid;

	if ((fid = open(dev, flags, 0644)) < 0) {
		perror("open");
		return(-1);
	}
	setraw(fid);
	fid = fid;
	return(fid);
}

close_midi(fid)
	int fid;
{
	clrraw(fid);
	close(fid);
	return(0);
}

midi_out(fid, c)
	int fid;
	u_char c;
{
	if (fid <= 0) {
		fprintf(stderr, "midi_out: invalid fid=%d\n", fid);
		return(-1);
	}

	if (write(fid, &c, sizeof(u_char)) != sizeof(u_char)) {
		perror("write");
		return(-1);
	}
	return(0);
}

u_char
midi_in(fid)
	int fid;
{
	u_char c;

	if (fid <= 0) {
		fprintf(stderr, "midi_in: invalid fid=%d\n", fid);
		return(-1);
	}

	if (read(fid, &c, sizeof(u_char)) != sizeof(u_char)) {
		perror("read");
		return(-1);
	}
	return(c);
}
E 1
