h36122
s 00047/00000/00000
d D 1.1 85/06/03 10:08:48 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <sys/types.h>
#include <carl/dx7.h>

/*
 * get_ctl_name -	get channel controller name
 * takes:
 * 	fid -		file descriptor for possible diagnostic output
 * 	synth_type -	manufacturer's midi id number
 * 	index -		controller index to be named
 * returns:
 * 	static string name
 * notes:
 *   	This routine vectors the index to the proper
 *   	disassembler based on the decoded manufacturer's midi id number.
 *   	This routine must be modified to add controller name disassembly
 *   	for additional synthesizers.
 *   	1) add an #include statement for its library header file, which
 *   		must contain a macro for the manufacturer's midi ID number,
 *  	2) insert a case statement below to call the routine.
 *   	3) the routine should return a static string value
 */


char *
get_ctl_name(fid, synth_type, index)
	FILE	*fid;
	int 	synth_type,
		index;
{
	extern char *dx7_ctl_name();

	switch (synth_type) {
		case ID_DX7:
			return(dx7_ctl_name(index));
		default:
			fprintf(fid,
			    "get_ctl_name: no such synthesizer id = %d\n",
			    synth_type);
			break;
	}
	return(NULL);
}
E 1
