#include <stdio.h>
#include <carl/libcarlmidi.h>

#define md(a,b,c) ((long)(a)*(long)(b))/(long)(c)
#define transform(v, a, b, A, B) md(B-A, v-a, b-a) + A

TransformMpuCmd(m, a, b, A, B)
	MpuCmd *m;
	unsigned char a, b, A, B;
/*
** Transform the pitch of 'MpuCmd' 'm' by scaling it from
** the range 'a...b' to the range 'A...B'.
** Pitches outside the range 'a...b' are unchanged.
** For instance, if pitches are in the range '30...50',
** the call 'TransformMpuCmd(m, 30, 50, 50, 30)'
** inverts the pitches.
*/
{
	register unsigned char p;
	if (IsNote(m) && (p=MpuPitch(m)) >= a && p <= b)
		MpuPitch(m) = transform(p, a, b, A, B);
}

MidiTransform(in,out,low,high,Low,High)
	FILE *in, *out;
/*
** Copy the midi data from 'in' and map pitch values in range
** 'low...high' to 'Low...High' (using 'TransformMpuCmd()'.
** Example: 'MidiTransform(in,out,dx7_MIN,dx7_MAX,dx7_MAX,dx7_MIN)'
** inverts pitches on the dx7 keyboard.
*/
{
	MpuCmd m;
	while (GetMpuCmd(in,&m)) {
		TransformMpuCmd(&m,low,high,Low,High);
		PutMpuCmd(out,&m);
	}
}
