#include <stdio.h>
#include <carl/libcarlmidi.h>
static Period = MPU_CLOCK_PERIOD;
#d scale(n) (long)((float)(n)*factor)

MidiStretch(in,out,factor)
	FILE *in, *out;
	float factor;
/*
** Copy MIDI data from 'in' to 'out', multiplying the times by 'factor'
** to stretch or compress the events.
** Example: 'MidiStretch(in,out,.5)' halves the rate (playing the data
** twice as fast).
*/
{
	MpuCmd m;
	long cum = 0;
	int put, t;
	while (GetMpuCmd(in,&m)) {
		if (m.time_tag == RT_TCIP)
			t = scale(Period), put = 0;
		else
			t = scale(m.time_tag), put = m.mpu_cmd[0] != RT_TCWME;
		cum += t;
		if (cum >= 2*Period){
			cum = t - (cum - 2*Period);
			t -= cum;
			PutTCWME(out,cum);
			cum = t;
		}
		if (put)
			m.time_tag = (unsigned char)t,
			m.mpu_time = (long)t,
			PutMpuCmd(out,&m);
	}
}
