#include <stdio.h>
#include <carl/libcarlmidi.h>

static	int	Period = MPU_CLOCK_PERIOD;
static	long	last = 0;
static	long	nexttcwme = 2*MPU_CLOCK_PERIOD;

MidiClockPut(out, Mp, when)
FILE	*out;
MpuCmd	*Mp;
long	when;
/*
** Write MIDI commands on 'out', adding TCIP & TCWME commands.
** Ignore the times specified in the MpuCmd entry, just use "when".
** Also ignore TCIP & TCMWE commands.
** The calls to MidiClockPut must occur in chronological order.
** Example: 'MidiClockPut(out, &m, t)' writes out the event in m
** (assuming it's not a TCIP or TCWME command) such that it will be
** played at time t, inserting any Timing Clock In Progress or Timing
** Clock With Measure End commands as necessary.
** NOTE: a call with Mp = 0 will pad timing commands out to the next
** measure end and reinitialize the static data for another run.
** Example: 'MidiClockPut(out, 0, 0)'
*/
{
	int put, dur;
	long next;

	if (Mp == (MpuCmd *) 0)
		when = nexttcwme;
	else if (Mp->time_tag == RT_TCIP || Mp->mpu_cmd[0] == RT_TCWME)
		return;
	do {
		next = nexttcwme < when? nexttcwme : when;
		while (next - last >= Period)
			PutTCIP(out), last += Period;
		if (next == nexttcwme) {
			PutTCWME(out, next - last);
			last = next;
			nexttcwme = last + 2 * Period;
		}
	} while (next < when);
	if (Mp == (MpuCmd *) 0) {
		last = 0;
		nexttcwme = last + 2 * Period;
	} else {
		Mp->time_tag = (unsigned char) next - last;
		Mp->mpu_time = (long) next - last;
		PutMpuCmd(out, Mp);
		last = next;
	}
}
