h12044
s 00050/00000/00000
d D 1.1 84/12/21 11:06:55 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <sys/types.h>
#include <carl/midi.h>
#include <carl/dx7.h>

/*
 * vdx7(dx, ch)			- virtual dx7
 * 	struct dx7 *	dx;	- state structure
 * 	u_char		ch[3];	- midi command
 * returns:
 * 	-1 on unknown command
 * side effects:
 * 	sets parameter on state structure
 * notes:
 * 	Only accepts channel commands.
 */

vdx7(dx, ch)
	struct dx7 *	dx;
	u_char		ch[3];
{
	switch (ch[0]) {
		case CH_KEY_OFF:
			if (dx->dx7_kbd_val[ch[1]] != 0)
				dx->dx7_nsv--;
			dx->dx7_kbd_val[ch[1]] = 0;
			break;
		case CH_KEY_ON:
			if (dx->dx7_kbd_val[ch[1]] == 0 && ch[2] != 0)
				dx->dx7_nsv++;
			dx->dx7_kbd_val[ch[1]] = ch[2];
			break;
		case CH_CTL:
			dx->dx7_ctl_val[ch[1]] = ch[2];
			break;
		case CH_PRG:
			dx->dx7_prg_val = ch[1];
			break;
		case CH_P_BEND:
			dx->dx7_pbd_val = (ch[1] << 8) | ch[2];
			break;
		default:
			fprintf(stderr, "vdx7: unknown channel command=%d\n",
				ch);
			return(-1);
	}
	return(0);
}
E 1
