#include <carl/cmusic.h>
set listfile = fm.list;
set funclength = 8K;
ins 0 fml; 
    /*env*/		seg b5 1 p5 d 0;
    /*df scale*/  	mult b2 b5 p9;
    /*amp scale*/ 	mult b3 b5 p6;
    /*mod osc*/		osc b4 b2 p8 f1 d;
    /*sum*/		adn b1 b4 p7;
    /*carrier*/		osc b1 b3 b1 f1 d;
    /*output*/		out b1;
end;

/*f1 - sine*/
gen 0 gen5 f1 1,1,0;
/*f3 - plucked envelope*/
#define PL 3
gen 0 gen4 f3 0 0 -3,  .005 1 -2,  1 0;

#define BELL 3*p7 2*p8 

/*
 * p5 is envelope function
 * p6 is amplitude
 * p7 is carrier frequency
 * p8 is the modulating frequency
 * p9 is the FM index
 */

/*
 * /1*1	p2	p3	p4	p5	p6	p7	p8	p9  *1/
 * note	0	fml	1	3	-12dB	261Hz	BELL;
 * ter;
 */
