h63913
s 00021/00027/00054
d D 1.2 85/10/24 09:57:29 dgl 2 1
c mpu_trk and mpu_trkp enhancements.
e
s 00081/00000/00000
d D 1.1 85/10/15 16:19:19 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

/* %M%	%I%	(CARL)	%G%	%U% */

/*
D 2
 * next_cmd -	set up mpu_trk structure to point to next mpu command
E 2
I 2
 * next_cmd -	set up mpu_trkp structure to point to next mpu command
E 2
 * takes:
D 2
 * 	struct mpu_trk	*trk;	pointer to track structure
E 2
I 2
 * 	struct mpu_trkp	*trkp;	pointer to track structure
E 2
 * returns:
 * 	number of bytes in next mpu command (0 if done), or
 * 	-1 on illegal timetag ( > 0xef)
 * side effects:
D 2
 * 	sets track position and length fields on mpu_trk structure.
E 2
I 2
 * 	sets track position and length fields on mpu_trkp structure.
E 2
 */

# include "medit.h"
# define u_char	unsigned char

D 2
next_cmd(trk)
	struct mpu_trk	*trk;
E 2
I 2
next_cmd(trkp)
	struct mpu_trkp	*trkp;
E 2
{
	extern int	printit;
D 2
	register int 	cnt  = trk->trk_cnt, 
E 2
I 2
	register int 	cnt  = trkp->trkp_trk->trk_cnt, 
E 2
			i;
D 2
	register u_char	*buf = trk->trk_buf;
E 2
I 2
	register u_char	*buf = trkp->trkp_trk->trk_buf;
E 2
	int		rtn = 0;

D 2
	i = trk->trk_pos + trk->trk_mlen; 
E 2
I 2
	i = trkp->trkp_pos + trkp->trkp_inc; 
E 2
	if (i < cnt) {
		if (printit == 5)
			printf("buf[%d]=%x\n", i, buf[i] & 0xff);
		if (buf[i] == (u_char) 0xf8) {		/* mpu measure */
D 2
			trk->trk_pos = i;
			trk->trk_mlen = rtn = 1;
E 2
I 2
			trkp->trkp_pos = i;
			trkp->trkp_inc = rtn = 1;
E 2
		} else if (buf[i] > (u_char ) 0xef) {
			rtn = -1;			/* illegal timetag */
		} else if ((buf[i+1] & (u_char) 0xf0) == (u_char) 0xf0) {	
D 2
			trk->trk_pos = i;		/* mpu mark */
			trk->trk_mlen = rtn = 2;
E 2
I 2
			trkp->trkp_pos = i;		/* mpu mark */
			trkp->trkp_inc = rtn = 2;
E 2
		} else if (buf[i+1] >= 0xc0 && buf[i+1] <= 0xdf) {
D 2
			trk->trk_pos = i;
			trk->trk_mlen = rtn = 3;
E 2
I 2
			trkp->trkp_pos = i;
			trkp->trkp_inc = rtn = 3;
E 2
		} else {
D 2
			trk->trk_pos = i;
			trk->trk_mlen = rtn = 4;
E 2
I 2
			trkp->trkp_pos = i;
			trkp->trkp_inc = rtn = 4;
E 2
		}
	}
	return(rtn);
}

D 2
rewind_trk(trk)
	struct mpu_trk	*trk;
{
	trk->trk_pos = trk->trk_mlen = 0;
}

E 2
/*
D 2
 * 
E 2
 * unsigned char x[] = {0xf8, 0xde, 0xf9, 0xf8, 0xf8, 0x0, 0xf9, 0xf8, 
 * 	0x78, 0x90, 0x3c, 0x3c};
 * 
 * struct mpu_trk	trk = {
 * 		x,
 * 		12,
 * 		12,
I 2
 * };
 * struct mpu_trkp trkp = {
 * 		&trk,
E 2
 * 		0,
 * 		0
 * };
 * 
D 2
 * int printit = 1;
 * 
E 2
I 2
 * int printit = 5;
E 2
 * 		
 * main()
 * {
 * 	int	len;
 * 
D 2
 * 	while ((len = next_cmd(&trk)) > 0)
E 2
I 2
 * 	while ((len = next_cmd(&trkp)) > 0)
E 2
 * 		continue;
 * }
D 2
 * 
E 2
 */
E 1
