# include "../libxcmpu/xc_mpu.h"
typedef Player * Pptr;
# define FOREVER -1
Pptr 	v[8];

int	key;

keydown()
{
	int	ch;

	if (nb_acia_read(0, &ch) != 0) {
		acia_write(0, ch);
		key = ch;
		return(TRUE);
	} else
		return(FALSE);
}

M_start() {
	trap_init();
	mpu_init();
	start_watch_pedal(0);
	fprintf(1, "ubrk=0x%x (%d)\n", stat_ubrk(), stat_ubrk());
}

M_ter()
{
	stop_ptm();
	m_mpureset(0);
	exit(0);
}

int ter;

Player keytest(0)
{
	P_start {
		ter = 0;
		Wait_for(keydown, CONTINUOUS);
		Return;
	}

	switch (key) {
		register int	i, j;
		case 'D':
			j = Rand() % 4000 + 50;
			for (i = 0; i < 8; i++) {
				Set_p(v[i], 2L, j);
				Stop(v[i]);
			}
			break;
		case '!':
			for (i = 0; i < 8; i++)
				Start(v[i]);
			break;
		case '.':	/* quit */
			ter = 1;
			Kill(Self);
			Return;
		case 'd':	/* change duration */
			for (i = 0; i < 8; i++) {
				Set_p(v[i], 2L, Rand() % 4096 + 50);
			}
			break;
		case 's':
			sRand(Rand());
			break;
		case 't':	/* change timbre */
			for (i = 0; i < 8; i++) {
				Set_p(v[i], 3L, Rand() % 32);
			}
		default:
			break;
	}
	acia_write(0, key);
}

Player note()
{
	Instance int sequence; 
	Instance int key, chan;
	int vel, next;

	switch (sequence) {
		case 0:
			chan = P5;
			key = P6;
			vel = P7;
			note_on(chan, key, vel);
			next = Now + P4;
			Wait_until(next);
			sequence = 1;
			break;
		case 1:
			note_off(chan, key);
			Kill(Self);
			break;
	}
}


Player track() 
{
	Pptr	v;
	Instance int	dur, chan, key, vel, timbre;

	P_start {
		timbre = -1;
		chan = P1;
	}
	if (ter) {
		Kill(Self);
		Return;
	}
	acia_write(1, P1 + '0');

	if ((v = New_player(note, Now, FOREVER, P_READY)) == NULL) {
		fprintf(0, "New_player failed\n");
		exit(1);
	}
	dur = P2;
	if (timbre != P3)
		new_timbre(chan, timbre = P3 % 32);
	key = Rand() % 128;
	vel = Rand() % 128;
	Set_p(v, 4, dur);
	Set_p(v, 5, chan);
	Set_p(v, 6, key);
	Set_p(v, 7, vel);
	Join(ALL_CHILDREN);
}


Player agent(0)
{
	int		i;

	for (i = 0; i < 8; i++) {
		if ((v[i] = New_player(track, Now, FOREVER, P_READY)) == NULL) {
			fprintf(0, "New_player failed\n");
			exit(1);
		}
		Set_p(v[i], 1L, i);
		Set_p(v[i], 2L, Rand() % 4000 + 50);
		Set_p(v[i], 3L, i);
	}
	Kill(Self);
}
