#include <carl/Player.h>
#include "debug.h"
#define NULL 0

/*
 * run_arbiter -	runtime scheduler
 * side effects:
 * 	Fetches next Player instance to run from get_wait().
 * 	Sets Player instance status to P_KILLED if 
 * 		action time >= begin time + duration.
 * 	Updates global time variable Now, and action time of Player.
 * 	Set Player status to P_RUNNING.
 * 	Sets global Player instance pointer Self.
 * 	Calls Player proc.
 */

run_arbiter()
{
	register Player *p, z;

	do {
		/* is it an active player? */
		if ((p = get_wait()) == NULL)
			break;
		if (p->runstat > P_RUNNING) {
# ifdef P_DEBUG
			if (_Pdebug & RUN_ARBITER)
			    printf( 
				"run_arbiter: runstat for %s:%x = %d\n",
				p->name, p, p->runstat);
# endif P_DEBUG
			continue;
		}
		/* has it run its span? */
  		/* if (p->ptime >= p->beg + p->dur) { */
		if (p->p_et == P_GT 
		    ? p->ptime > p->beg + p->dur
		    : p->ptime >= p->beg + p->dur) {
# ifdef P_DEBUG
			if (_Pdebug & RUN_ARBITER)
			    printf( "run_arbiter: killing %s:%x\n",
				p->name, p);
# endif P_DEBUG
			Kill(p);
			continue;
		}
		if (p->ptime > Now) {
			if (Realtime) {
				register long diff = p->ptime - Now;

				if (diff > 0) {
# ifdef P_DEBUG
					if (_Pdebug & RUN_ARBITER)
						printf(
						    "isleep:%s:%d==%d - %d\n",
							p->name,
							diff,
							p->ptime, Now);
# endif P_DEBUG
					isleep(diff);
				}
			}
			Now = p->ptime;		/* update global time */
		} else
			p->ptime = Now;		/* update private time */
		Self = p;		/* set global who-am-i */
		p->runstat = P_RUNNING;	/* make this the running proc. */
# ifdef P_DEBUG
		if (_Pdebug & RUN_ARBITER)
		    printf( "run_arbiter: %d:\trunning %s:%x\n", 
			Now, p->name, Self);
# endif P_DEBUG
		z = (p->cproc)(Self);	/* call it */
		p->icode = 1;		/* set init. flag done */
		if (p->runstat == P_RUNNING) {	/* still running? */
			if (Out_proc != NULL)
				(*Out_proc)(p);	/* call output routine */
			p->runstat = P_READY;	/* reset status */
		}
		Self = NULL;
	} while (1);
}

/*
 * psPlayer(x)
 * 	Player *x;
 * {
 * fprintf((FILE *)stderr, 
 * 	"%s\tNow=%d, beg=%d, dur=%d, ptime=%d, %s\n",
 * 	x->name, Now, x->beg, x->dur, x->ptime, 
 * 	x->runstat == P_STOPPED ? "STOPPED" : "RUNNING");
 * }
 */
