/* #include <stdio.h> */
#define NULL 0
#include <math.h>
#include <carl/libran.h>
#include <carl/carl.h>

#define PITCHES 12
#define Return return(*Self)
#define OUTPROC cmusout
#define Forever HUGE
#define QLEN 100
#define TIME_QLEN 10.0 
/* macros for the state of a player */
#define P_NOSTAT 	0
#define P_READY 	1
#define P_RUNNING 	2
#define P_STOPPED 	3
#define P_KILLED 	4
/* macros for the state of a test procedure via wait_for() */
#define ONCE 		0
#define CONTINUOUS 	1
#define ALL_CHILDREN 	1
#define EACH_CHILD 	2

#define TRUE 1
#define True TRUE
#define FALSE 0
#define False FALSE
# define bit(x)		(1 << x)
# define P_GT		0
# define P_GE		1

extern int	Realtime;	/* if TRUE, run_arbiter() will sleep */

/* set by Rhythms, Pitches, Numbers, Strings and friends */
extern long Player_stat;
# define P_STOP_SET	bit(0)
# define P_REST_SET	bit(1)
# define P_HOLD_SET	bit(2)
# define P_EXPR_ERR	bit(3)
# define P_NULL_PTR	bit(4)
# define P_NO_PARAM	bit(5)
# define P_WRAP		bit(6)
# define P_MEAS		bit(7)

#define INITCLIST(X) while (X->np->datum == NULL) X->np = X->np->nxtnot;

struct n_list 
{
	struct noteheader      *n_head;
	struct noteheader      *n_tail;
};

extern char    *malloc ();
extern char    *calloc ();
extern char    *realloc ();

extern int      argc;
extern char   **argv;
extern long     _Pdebug;

struct player 
{
	struct player (*cproc)();/* pointer to player function */
	int     (*iproc)();	/* pointer to init function */
	char   *name;		/* its name */
	struct player  *p_next;
	struct player  *p_last;
	struct player  *caller;	/* address of parent's instance data, if any */
	char   *nstnc;		/* local instance structure tacked on here */
	long  	beg,		/* time player is slated to start */
	        dur,		/* time player is slated to end */
	        ptime;		/* current absolute time of the player */
	short	n_children;	/* number of childern of this proc. */
	unsigned
		p_et:1,		/* select end test criterion */
                silent:1, 	/* if true, suppress default output */
                icode:1,	/* flag for once-only code */
                runstat:3,	/* status of player */
                reststat:1, 	/* suppress output temporarily */
                chordstat:1, 	/* chord symbol was parsed in cyclic list */
		child_wait:2;	/* indicates waiting for children to exit */
};

typedef struct player   Player;

extern  Player read_stdin ();
extern  Player poll_waits ();

struct p_list 
{
	Player * p_head;
	Player * p_tail;
};

extern struct n_list    nlist;	/* cyclic lists */
extern struct p_list    plist,	/* Player classes */
                        ilist;	/* Player instances */

struct wait_f 
{
	int     (*f_proc) ();	/* pointer to proc. that determines wait */
	Player * f_pp;		/* pointer to player owning this wait */
	unsigned	f_divcnt;
	unsigned        f_flag:1;
	struct wait_f
	               *f_next,
	               *f_last;
};

typedef struct prq_node {	/* the selected object or structure */
	int prq_rank;
	struct prq_node *prq_left, *prq_right;
	int prq_dist;
	Player *prq_po;
	int prq_void;
} **prq;	/*   prq is a ptr to a ptr to a node  	*/

extern struct wait_u tlist[QLEN];/* time wait list */

extern struct wait_f *wlist;	/* polled event wait list */

extern  Player * get_wait ();
extern  Player * mk_Player ();

#define Function FUNCTION
extern  Function * Read_func ();
extern  Function * Gen ();
extern double   Func ();
extern double   Rel_func ();
extern double   add_player ();

#define NOTETYPE 1
#define RHYTYPE 2
#define STOPSTR "Stop"
#define RESTR "r"
#define KEYSIG 'K'
#define TIMESIG 'T'
#define HOLDSTR "Hold"

struct notnod 
{
	struct notnod
	       *nxtnot,
	       *lstnot,
	       *f_branch,
	       *b_branch;
	int     f_bcnt,		/* controlled variable foreward loop count */
		b_bcnt,		/* controlled variable backward loop count */
		f_times,	/* limit variable of foreward loop count */
		b_times;	/* limit variable of backward loop count */
	char   *datum,
	       *measure_id;
	int	n_type;
	unsigned	chord_element:1;
};


struct keysig {
	char *key_sig;		/* string key signature */
	char key[PITCHES];	/* array of key signature accidentals */
	char acc[PITCHES];	/* temporary accidentals */
};

struct timesig {
	char   *time_sig;	/* string time signature */
	int	num;		/* numerator of signature */
	int	den;		/* denominator of signature */
};


struct noteheader 
{
	char   *nid;		/* addr. of char * for this cyclic list */
	char   *raw;		/* undigested string */
	char   *nn;		/* label of this cyclic list */
	int     type;
	int     Nnotes;
	int	incr;
	struct notnod
	       *nh,			/* head of parsed list */
	       *np,			/* pointer to next notnod */
	       *nt;			/* tail of parsed list */
	char   *last_val;		/* for Hold instruction */
	float   oct;			/* conservation of octave */
	struct keysig   ac_list;	/* conservation of accidentals */
	struct timesig  *h_time_sig;	/* time signature */
};

extern struct	noteheader	*getid();
extern long   Now;
extern int      plistcnt;
extern int      ilistcnt;
extern int      nlistcnt;
extern int      trim_zeros;
extern double   Pitch ();
extern double   Octave ();
extern double   Pitches ();
extern double   Key ();
extern double   Keys ();
extern double   Rhythm ();
extern double   Rhythms ();
extern double   Expr ();
extern double   Exprs ();
extern char    *Strings ();
extern int      Motive ();
extern char    *Index ();
extern char    *Get_list ();
extern char    *Getcladdr ();
extern int      Rd_motive ();
extern char     notend;		/* set by notes() and rhythms() */
extern char     noterest;	/* set by notes() */
extern double Wait_for_interval;/* used in poll_waits.m */
extern double   P ();
extern char    *Ps ();
extern char    *Pp ();
extern double   Scale[];
extern  Player * New_player ();
extern  Player * Caller ();
extern  Player * new_Player ();
extern int      (*Out_proc) ();
extern int      cmusout ();
extern  Player * Self;
extern int      wfun_cnt;
extern double   Tempo ();

struct symtab {
	int 		ss_type;
	char *		ss_name;
	struct hlist **	ss_hlist;
	unsigned	ss_collisions;
	unsigned	ss_installs;
};

extern struct symtab symtab[];	/* from symtab.c */

/* symbol tables */
/* these are hashed by their memory address */
# define ST_CLASS	0	/* Player class template data */
# define ST_CYCLIST	1	/* cyclic lists */
/* these are hashed by the value of their string name */
# define ST_CYCLABL	2	/* cyclic list label */
# define ST_STR_CLASS	3	/* Player class template data */

# define AT_CLASS	&symtab[ST_CLASS]
# define AT_CYCLIST	&symtab[ST_CYCLIST]
# define AT_CYCLABL	&symtab[ST_CYCLABL]
# define AT_STR_CLASS	&symtab[ST_STR_CLASS]

/* prime number for symbol table length helps the hashing function */
# define HSIZE		61

/*
 * types of things that are managed
 * by a symbol table. each has its
 * own symbol table.
 */
union vals {
	Player * st_class;
	struct wait_f  *st_waitf;
	struct wait_u  *st_waitu;
	struct noteheader      *st_cycl;
};

/*
 * structure of a symbol table
 * entry.
 */
struct hlist {
	char   *hl_sym;		/* symbolic name */
	struct hlist   *hl_next;/* next hash entry */
	                union vals hl_val;/* value to store */
};

extern struct hlist    *lookup ();
extern struct hlist    *install ();
extern struct timesig *Get_timesig();
extern struct keysig *Get_keysig();
