/* %M%	%I%	(CARL)	%G%	%U% */

#include <carl/Player.h>

static Player *poll;

void Wait_for(proc, status)
	register int (*proc)();
	register int status;
/*
 * Cause Player to wait for an event.
 * .TP
 * Takes:	
 * .IP Self
 * picked up globally.
 * .IP proc
 * address of decision procedure.
 * .IP status
 * one-shot or continuous:
 * .RS
 * .TP 18
 * ONCE 
 * wait for event one time.
 * .TP 18
 * CONTINUOUS 
 * wait for event continuously.
 * .RE
 * .TP
 * Returns:	void
 * .TP
 * Side effects: 
 * (Timesharing version)
 * If no waits in progress, start builtin Player poll_waits.
 * Link to list of all Wait_for elements.
 */
{
	register struct wait_f *p;

	if ((p = (struct wait_f *) 
		malloc((unsigned) sizeof(struct wait_f))) == NULL)
			malerr("Wait_for", 1);
	p->f_proc = proc;
	p->f_pp = Self;
	p->f_flag = status;
	if (wlist == NULL) {	/* no waits in progress */
		p->f_next = p->f_last = NULL;
		/* start up the poller */
		if ((poll = New_player(poll_waits, Now, HUGE, P_READY))==NULL){
			fprintf(stderr, "Wait_for: New_player failed\n");
			Pexit(1);
		}
	} else {
		wlist->f_last = p;
		p->f_next = wlist;
	}
	wlist = p;
}


Unwait_for(proc)
	register int (*proc)();
Cause Player to no longer wait for an event.
.TP 18
Takes:		
.TP 18
Self
picked up globally.
.TP 18
proc
address of decision procedure.
.TP 18
Returns:	
-1 if proc not found, otherwise 0 on success.
.TP 18
Side effects:	
Removes proc from linked list of Wait_for elements.

	for (p = wlist; p != NULL; p = p->f_next) {
		if (p->f_proc == proc && p->f_pp == Self) {
			/* patch around this on wlist */
			if (p->f_last != NULL)
				p->f_last->f_next = p->f_next;
			if (p->f_next != NULL)
				p->f_next->f_last = p->f_last;
			if (wlist == p)
				wlist = p->f_next;
			free((char *) p);
			break;
		}
	}
	if (wlist == NULL) {
		if (poll != NULL)
			if (Kill(poll) == P_NOSTAT) {
				fprintf(stderr, 
					"Unwait_for: Kill(poll) failed\n");
				Pexit(1);
			}
	}
	return(0);
}

/*
 * wf_clear - delete all references to Player x from wlist
 * takes:
 * 	x -	Player to remove all wait_for's
 * notes:
 * 	used by garbage collector to clean up after Kill()ed voice.
 */

wf_clear(x)
	Player *x;
{
	register struct wait_f *p;

	for (p = wlist; p != NULL; p = p->f_next) {
		if (p->f_pp == x) {
			/* patch around this on wlist */
			if (p->f_last != NULL)
				p->f_last->f_next = p->f_next;
			if (p->f_next != NULL)
				p->f_next->f_last = p->f_last;
			if (wlist == p)
				wlist = p->f_next;
			free((char *) p);
		}
	}
	if (wlist == NULL) {
		if (poll != NULL && x != poll) {
			if (Kill(poll) != 0) {
				fprintf(stderr, 
					"wf_clear: Kill(poll) failed\n");
				Pexit(1);
			}
			poll = NULL;
		}
	}
	return(0);
}
