h21523
s 00000/00000/00161
d D 2.1 85/10/26 23:40:08 dgl 2 1
c changed variable names.
e
s 00161/00000/00000
d D 1.1 84/12/21 12:06:45 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <carl/Player.h>
#include <ctype.h>
#include <carl/defaults.h>

/*
 * Read_func - read named floatsam function file
 * takes:
 * 	name - name of file
 * 	type - sequence type: H_MONO_IN_X, or H_XY_PAIRS,
 * 		defined in <carl/defaults.h>
 * side effects:
 * 	Creates and fills a FUNCTION structure with data in file, interpreted
 * 	according to header on the file being read, or in the absence
 *	of a header, according to the type argument.
 * returns:
 * 	pointer to FUNCTION structure.
 *	NULL if not found, or error.
 */
	
FUNCTION *
Read_func(name, type)
	register char 	*name, 	/* file name of function */
			*type;	/* sequence type: H_MONO_IN_X, or H_XY_PAIRS */
{
	return(read_func_file(name, type));
}


/*
 * Gen - get function from pipe. 
 * takes:
 * 	cmd -	complete command string to pass to popen()
 * returns:
 * 	NULL on errors otherwise, the desired function
 * side effects:
 * 	Name field of function is set to the command that generated it.
 * notes:
 * 	Default type is H_MONO_IN_X.
 */

FUNCTION *
Gen(cmd)
	register char *cmd;
{
	extern char		*strcpy();
	extern FILE 		*popen(); 
	extern FUNCTION		*getgenfunc();
	register FILE 		*pp;
	register FUNCTION 	*x; 

	if ((pp = popen(cmd, "r")) == NULL) {
		fprintf(stderr, "gen: popen failed on command:\n``%s''\n", cmd);
		return(NULL);
	}
	/* read function, coerce to be mono in x if no header */
	x = read_func_fid(pp, H_MONO_IN_X);
	if ((x->fname = (char *) malloc((unsigned) strlen(cmd)+1)) == NULL)
		malerr("Gen", 1);
	(void) strcpy(x->fname, cmd);
	return(x);
}

/* 
 * Func_length -	return the length of a function 
 */

long
Func_length(f)
	register FUNCTION *f;
{
	if (f != NULL)
		return(f->flen);
	else
		return(-1);
}

/*
 * Func -	return the y-value for the value on the function at x.  
 * takes:
 * 	f -	FUNCTION to be interpolated
 * 	x -	floating point index
 * returns:
 * 	value of function at that index.
 * notes:
 * 	If x has a fractional part, linear interpolation is used to find 
 *		the value.
 * 	Works for both H_MONO_IN_X and H_XY_PAIRS
 */

double 
Func(f, x)
	register FUNCTION *f; 
	register double x;
{
	register long ind;
	register double frac;

	if (f == NULL) {
		fprintf(stderr, "func: NULL function!\n");
		Player_stat |= P_NULL_PTR;
		return(0.0);
	} else
		Player_stat &= ~P_NULL_PTR;
	if (!strcmp(f->ftype, H_MONO_IN_X)) {
		ind = x;
		frac = x - ind;
		if (ind >= f->flen-1)
			return(f->fyval[f->flen-1]);
		if (ind < 0)
			return(f->fyval[0]);
		else
			return((1.0 - frac) * f->fyval[ind] 
				+ frac * f->fyval[ind+1]);
	}
	else
	if (!strcmp(f->ftype, H_XY_PAIRS)) {
		register double Y1, Y2, X1, X2; 

		for (ind = 0; ind < f->flen-1; ind++) {
			if (f->fxval[ind] > x) {
				break;
			}
		}
		X2 = f->fxval[ind];
		Y2 = f->fyval[ind];
		X1 = f->fxval[ind-1];
		Y1 = f->fyval[ind-1];
		frac = (x - X1)/(X2 - X1);
		return((1.0 - frac) * Y1 + frac * Y2);
	}
	return(0.0);
}

/*
 * Rel_func -	index function by unit interval
 * takes:
 * 	f -	function to index
 * 	x -	floating point index
 * returns:
 * 	value of function at that index
 * notes:
 * 	The function is taken as having a range of [0,1).
 * 	Value computed by linear interpolation as necessary.
 * 	Indicies outside the [0,1) interval are truncated.
 */

double 
Rel_func(f, x)
	register FUNCTION *f; 
	register double x;
{
	Player_stat &= ~P_NULL_PTR;
	if (f == NULL) {
		fprintf(stderr, "rel_func: NULL function!\n");
		Player_stat |= P_NULL_PTR;
		return(0.0);
	}
	return(Func(f, x * f->flen));
}
E 1
