/* rdclist.c	2.1	(CARL)	10/26/85	23:40:36 */

#include <stdio.h>
#include <carl/Player.h>
#include <ctype.h>

/*
 * get_clist -	get next cyclic list from file
 * takes:
 * 	fp -	file pointer
 * returns:	string form of cyclic list
 */

char *
get_clist(fp)
	register FILE *fp;
{
	register int c; 
	char *buf = NULL;

	for (;;) {
		if ((c = getc(fp)) == EOF || c == ';') {
			if (buf == NULL)		/* nothing saved? */
				break;			/* just return */
			else
				(void) strsav(&buf, '\0');/* else terminate */
			break;				/* and return */
		}
		if (buf == NULL && isspace(c))		/* kill initial */
			continue;			/* white space */
		else
			(void) strsav(&buf, c);
	}
	return(buf);
}

/* 
 * Read_lists - read all cyclic list strings from a file
 * takes:
 *	file -	file name containing cyclic list statements
 * side effects:
 *	Parses cyclic lists, installs them in ST_CYCLIST and ST_CYCLABL
 *	symbol tables.
 */

Read_lists(file)
	register char *file;
{
	register char *cnotes;
	register FILE *fp;

	if ((fp = fopen(file, "r")) == NULL) {
		fprintf(stderr, "Read_list_file: can't read: %s\n", file);
		Pexit(1);
	}

	while ((cnotes = get_clist(fp)) != NULL) {
		extern struct headcl_hcl *newid();
		register struct headcl_hcl *h = newid(cnotes);

		if (buildnotes(h, cnotes) == 0) {
			/* skip over any initial branch nodes */
			nextnot(h);
		}
		free(cnotes);
	}
	(void) fclose(fp);
}
