h10058
s 00012/00013/00080
d D 2.1 86/01/30 16:39:26 dgl 2 1
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00093/00000/00000
d D 1.1 85/11/06 12:38:01 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

D 2
/* %M%	%I%	(CARL)	%G%	%U% */

E 2
#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <carl/Player.h>

extern double Scale[];

/*
 * pc_oct -	compute pitch class and octave from cyclic list element
I 2
 * in Pitch-format.
E 2
 * takes:	
 *	str - string in Pitch format
 * 	oct - pointer to float to return octave
 * 	ac_list - state structure for sig_key
 * returns:	
 *	pitch
 *	-1 on errors
 *	-2 if key signature field is scanned.
 * side effects:
 *	Sets Player_stat if expr ==  STOPSTR or RESTR.
 * 	Sets prevailing octave by assignment into argument oct.
 *	Sets key signature and accidentals via ac_list.
 * notes:	
 *	Limited to 12-tone pitch classes.
 */

pc_oct(str, oct, ac_list) 
	register char *str;
	register float *oct;
	struct sig_key *ac_list;
{
	register int pitchclass, acoff;
	register char pc, ac = '\0';

	Player_stat &= ~(P_REST_SET | P_EXPR_ERR);
	if (!strcmp(str, RESTR)) {
		Player_stat |= P_REST_SET;
		return(-1);
	}
	if (*str >= 'a' && *str <= 'g') 	/* get pitch class */
		ac = pc = *str++;
	else {
		Player_stat |= P_EXPR_ERR;
		return(-1);
	}

	switch (pc) {				/* xlate to pitch number */
		case 'a': pitchclass = 9; break;
		case 'b': pitchclass = 11; break;
		case 'c': pitchclass = 0; break;
		case 'd': pitchclass = 2; break;
		case 'e': pitchclass = 4; break;
		case 'f': pitchclass = 5; break;
		case 'g': pitchclass = 7;
	}
	ac = '\0';
D 2
	if (*str == 's' || *str == 'f' || *str == 'n' 
		|| *str == 'S' || *str == 'F') { /* get accidental */
		ac = *str++;
		set_ac(pitchclass, ac, ac_list);
		switch (ac) {
			case 's': acoff = 1; break;
			case 'f': acoff = -1; break;
			case 'S': acoff = 2; break;
			case 'F': acoff = -2; break;
			case 'n': 
			default:  acoff = 0; break;
E 2
I 2
	acoff = 0;
	if (*str == 's' || *str == 'f' || *str == 'n') { /* get accidental */
		while (*str == 's' || *str == 'f' || *str == 'n') { /* get accidental */
			ac = *str++;
			switch (ac) {
				case 's': acoff += 1; break;
				case 'f': acoff -= 1; break;
				case 'n': 
				default:  acoff = 0; break;
			}
			set_ac(pitchclass, acoff, ac_list);
E 2
		}
	}
	else
		acoff = get_ac(pitchclass, ac_list);

	pitchclass += acoff;
	if (pitchclass < 0) 			/* modulo table length */
		pitchclass += PITCHES;
	if (pitchclass >= PITCHES) 
		pitchclass -= PITCHES;
	if (*str != '\0') {
		while (*str == '-' || *str == '+') {	/* relative octave */
			if (*str == '-')
				*oct -= 1.0;
			if (*str == '+')
				*oct += 1.0;
			*str++;
		}
		if (*str != '\0')			/* absolute octave */
			*oct = atof(str) - 4.0;	/* home octave is c4-b4 */
	}
	return(pitchclass);
}
E 1
