h49950
s 00010/00019/00020
d D 2.2 86/01/30 16:33:28 dgl 4 3
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00001/00001/00038
d D 2.1 85/10/26 23:39:04 dgl 3 2
c changed variable names.
e
s 00004/00000/00035
d D 1.2 85/09/30 12:48:22 dgl 2 1
c made type of argument being set conditional on P_FLOAT.
e
s 00035/00000/00000
d D 1.1 84/12/21 12:04:00 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <carl/Player.h>

D 4
/*
 * Set_p -	set P field in another Player
 * takes:
 * 	vp -	pointer to Player instance data
 * 	n -	P field index
 * 	val -	value
 * returns:
 * 	0 on success, -1 on error
 * side effects:
 * 	Sets Player_stat to P_NO_PARAM if no such P field.
 * 	Sets Player_stat to P_NULL_PTR if no such Player.
 */
E 4

Set_p(vp, n, val)
D 4
	register Player *vp;
	register int n;
I 2
#ifdef P_FLOAT
E 2
	register float val;
I 2
#else P_FLOAT
	register long val;
#endif P_FLOAT
E 4
I 4
	register Player *vp;	/* pointer to Player instance data */
	register int n;		/* P variable index */
	register P_TYPE val;	/* value */
/*
 * Set \fBP\fP-variable in a Player instance.
 * .LP
 * Returns 0 on success, \-1 on error.
 * Sets \fBPlayer_stat\fP to \fBP_NO_PARAM\fP if no such \fBP\fP-variable,
 * to \fBP_NULL_PTR\fP if no such Player, and returns \-1.
 */
E 4
E 2
{
	Player_stat &= ~(P_NULL_PTR | P_NO_PARAM);
	if (vp == NULL) {
		Player_stat = P_NULL_PTR;
		return(-1);
	}
		
	if (ckmaxp(vp, n) == -1) {
		Player_stat = P_NO_PARAM;
		return(-1);
	}
D 3
	vp->pn[n] = val;
E 3
I 3
	vp->P_pn[n] = val;
E 3
	return(0);
}
E 1
