h35490
s 00010/00014/00018
d D 2.2 86/01/30 16:32:31 dgl 3 2
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00001/00001/00031
d D 2.1 85/10/26 23:38:31 dgl 2 1
c changed variable names.
e
s 00032/00000/00000
d D 1.1 84/12/21 12:02:43 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <carl/Player.h>

D 3
/*
 * Pp -	fetch Pp field from another Player
 * takes:
 * 	vp -	pointer to Player instance data
 * 	n -	Pp field index
 * returns:
 * 	value, if found, otherwise 0.0
 * side effects:
 * 	Sets Player_stat to P_NO_PARAM if no such Pp field.
 *	Sets Player_stat to P_NULL_PTR if no Player instance data.
 */
		
E 3
I 3

E 3
char *
Pp(vp, n)
D 3
	register Player *vp; 
	register int n;
E 3
I 3
	register Player *vp;	/* pointer to Player instance data */
	register int n;		/* Pp variable index */
/*
 * Fetch \fBPp\fP-variable from a Player instance.
 * .LP
 * Returns value of \fBPp\fP-variable.
 * Sets \fBPlayer_stat\fP to \fBP_NO_PARAM\fP if no such \fBPp\fP-variable,
 * to \fBP_NULL_PTR\fP if no \fBPlayer\fP instance data, and returns 'NULL'.
 */
E 3
{
	Player_stat &= ~(P_NULL_PTR | P_NO_PARAM);
	if (vp == NULL) {
		Player_stat |= P_NULL_PTR;
		return(NULL);
	}
	if (ckmaxp(vp, n) == -1) {
		Player_stat |= P_NO_PARAM;
		return(NULL);
	}
D 2
	return(vp->pp[n]);
E 2
I 2
	return(vp->P_pp[n]);
E 2
}
E 1
