h15338
s 00021/00272/00053
d D 2.2 86/01/30 16:36:12 dgl 7 6
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00031/00031/00294
d D 2.1 85/10/26 23:41:20 dgl 6 5
c changed variable names.
e
s 00018/00006/00307
d D 1.4 85/10/11 12:02:02 dgl 5 3
c added Kill directive.
e
s 00018/00006/00307
d R 1.4 85/10/10 16:51:35 dgl 4 3
c Added ``Kill'' cyclic list directive.
e
s 00002/00002/00311
d D 1.3 85/09/30 13:45:30 dgl 3 2
c s/clist_directive/clist_direct/
e
s 00043/00061/00270
d D 1.2 85/03/13 23:00:47 dgl 2 1
c Overhaul of method of reporting conditions to caller.
c 
e
s 00331/00000/00000
d D 1.1 84/12/21 12:02:26 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <carl/Player.h>

D 7
double Scale[] = {
	261.625565,	/* c4 */
	277.182631,	/* cs4 */
	293.664768,	/* d4 */
	311.126984,	/* ds4 */
	329.627557,	/* e4 */
	349.228231,	/* f4 */
	369.994423,	/* fs4 */
	391.995436,	/* g4 */
	415.304698,	/* gs4 */
	440.000000,	/* a4 */
	466.163762,	/* as4 */
	493.883301	/* b4 */
};
E 7
I 7
extern double Scale[];
E 7

I 7
double Pitches(nl)
	register char *nl;
E 7
/*
D 7
 * pc_oct -	compute pitch class and octave from cyclic list element
 * takes:	
 *	str - string in Pitch format
 * 	oct - pointer to float to return octave
D 6
 * 	ac_list - state structure for keysig
E 6
I 6
 * 	ac_list - state structure for sig_key
E 6
 * returns:	
 *	pitch
 *	-1 on errors
 *	-2 if key signature field is scanned.
 * side effects:
 *	Sets Player_stat if expr ==  STOPSTR or RESTR.
 * 	Sets prevailing octave by assignment into argument oct.
 *	Sets key signature and accidentals via ac_list.
 * notes:	
 *	Limited to 12-tone pitch classes.
E 7
I 7
 * Evaluate string as cyclic list of \fBPitch\fP expressions.
 * .LP
 * Takes pointer to string of \fBPitch\fP fields in cyclic list format.
 * Returns pitch in Hz of evaluated expression.
 * Increments pointer to next expression field.
 * Sets \fBPlayer_stat\fP:
 * .in +5
 * .nf
 * to \fBP_HOLD_SET\fP 'if expr ==' \fBHOLDSTR\fP,
 * to \fBP_STOP_SET\fP 'if expr ==' \fBSTOPSTR\fP,
 * to \fBP_REST_SET\fP 'if expr ==' \fBRESTR\fP,
 * to \fBP_KILL_SET\fP 'if expr ==' \fBKILLSTR\fP.
 * .in -5
 * .fi
 * Will stop Player 'if expr ==' \fBSTOPSTR\fP.
 * Will kill Player 'if expr ==' \fBKILLSTR\fP.
 * Returns previous value if \fBHOLDSTR\fP is scanned, and does not 
 * increment pointer to next expression field.
E 7
 */
D 7

pc_oct(str, oct, ac_list) 
	register char *str;
	register float *oct;
D 6
	struct keysig *ac_list;
E 6
I 6
	struct sig_key *ac_list;
E 7
E 6
{
D 7
	register int pitchclass, acoff;
	register char pc, ac = '\0';

D 2
	Player_stat &= ~(P_STOP_SET | P_REST_SET | P_EXPR_ERR);
	if (!strcmp(str, STOPSTR)) {
		Player_stat |= P_STOP_SET;
		return(-1);
	}
E 2
I 2
	Player_stat &= ~(P_REST_SET | P_EXPR_ERR);
E 2
	if (!strcmp(str, RESTR)) {
		Player_stat |= P_REST_SET;
		return(-1);
	}
D 2
	if (*str == KEYSIG) {
		set_keysig(str+1, ac_list);
		return(-2);
	}
E 2
	if (*str >= 'a' && *str <= 'g') 	/* get pitch class */
		ac = pc = *str++;
	else {
		Player_stat |= P_EXPR_ERR;
		return(-1);
	}

	switch (pc) {				/* xlate to pitch number */
		case 'a': pitchclass = 9; break;
		case 'b': pitchclass = 11; break;
		case 'c': pitchclass = 0; break;
		case 'd': pitchclass = 2; break;
		case 'e': pitchclass = 4; break;
		case 'f': pitchclass = 5; break;
		case 'g': pitchclass = 7;
	}
	ac = '\0';
	if (*str == 's' || *str == 'f' || *str == 'n' 
		|| *str == 'S' || *str == 'F') { /* get accidental */
		ac = *str++;
		set_ac(pitchclass, ac, ac_list);
		switch (ac) {
			case 's': acoff = 1; break;
			case 'f': acoff = -1; break;
			case 'S': acoff = 2; break;
			case 'F': acoff = -2; break;
			case 'n': 
			default:  acoff = 0; break;
		}
	}
	else
		acoff = get_ac(pitchclass, ac_list);

	pitchclass += acoff;
	if (pitchclass < 0) 			/* modulo table length */
		pitchclass += PITCHES;
	if (pitchclass >= PITCHES) 
		pitchclass -= PITCHES;
	if (*str != '\0') {
		while (*str == '-' || *str == '+') {	/* relative octave */
			if (*str == '-')
				*oct -= 1.0;
			if (*str == '+')
				*oct += 1.0;
			*str++;
		}
		if (*str != '\0')			/* absolute octave */
			*oct = atof(str) - 4.0;	/* home octave is c4-b4 */
	}
	return(pitchclass);
}

/*
 * Pitches -	evaluate cyclic list as Pitch fields
 * takes:	
 *	nl -	pointer to string of Pitch fields in cyclic list format
 * returns:	
 *	pitch in Hz of evaluated field
 * side effects:	
 *	increments pointer to next expression field
 * 	sets Player_stat:
 * 		to P_HOLD_SET if expr == HOLDSTR
 * 		to P_STOP_SET if expr == STOPSTR
 * 		to P_REST_SET if expr == RESTR
I 5
 * 		to P_KILL_SET if expr == KILLSTR
E 5
 * notes:	
D 5
 *	May stop Player if expr == STOPSTR.
E 5
I 5
 *	Will stop Player if expr == STOPSTR.
 *	Will kill Player if expr == KILLSTR.
E 5
 *	Returns last value if HOLDSTR is set and does not increment
 *		pointer to next expression field.
 */

double 
Pitches(nl)
	register char *nl;
{
E 7
	register double frequency;
	register int rtn;
	register char *c;
D 6
	register struct noteheader *h = getid(nl);
E 6
I 6
	register struct headcl_hcl *h = getid(nl);
E 6

	_motive(h, nl);
D 2
skip:	if (nextnot(h) != 0)
		clr_ac(&h->ac_list);
	c = h->np->datum;
	if (!strcmp(HOLDSTR, c)) {
E 2
I 2
	Player_stat &= ~(P_STOP_SET|P_HOLD_SET|P_TIMESIG|P_KEYSIG
D 5
		|P_WRAP|P_MEAS|P_METRONOME|P_CHORD);
E 5
I 5
		|P_WRAP|P_MEAS|P_METRONOME|P_CHORD|P_KILL_SET);
E 5
	do {
		if (nextnot(h) != 0)
D 6
			clr_ac(&h->ac_list);
E 6
I 6
			clr_ac(&h->hcl_aclist);
E 6
D 3
	} while (clist_directive(h) != 0);
E 3
I 3
	} while (clist_direct(h) != 0);
E 3
D 5
	if (h->np->n_stop) {	/* stop this player */
E 5
I 5
D 6
	if (h->np->n_kill) {	/* kill this player */
E 6
I 6
	if (h->hcl_np->cl_kill) {	/* kill this player */
E 6
		Player_stat |= P_KILL_SET;
D 6
		Self->runstat = P_KILLED;
E 6
I 6
		Self->P_runstat = P_KILLED;
E 6
		return(1.0);
D 6
	} else if (h->np->n_stop) {	/* stop this player */
E 6
I 6
	} else if (h->hcl_np->cl_stop) {	/* stop this player */
E 6
E 5
		Player_stat |= P_STOP_SET;
D 6
		Self->runstat = P_STOPPED;
E 6
I 6
		Self->P_runstat = P_STOPPED;
E 6
		return(1.0);	/* return something safe */
	}
D 6
	else if (h->np->n_hold) {
E 2
		rtn = pc_oct(h->last_val, &h->oct, &h->ac_list);
E 6
I 6
	else if (h->hcl_np->cl_hold) {
		rtn = pc_oct(h->hcl_lastval, &h->hcl_oct, &h->hcl_aclist);
E 6
		Player_stat |= P_HOLD_SET;
	} else {
D 2
		if ((rtn = pc_oct(c, &h->oct, &h->ac_list)) == -2)
			goto skip; /* skip key signature */
E 2
I 2
D 6
		c = h->np->datum;
		rtn = pc_oct(c, &h->oct, &h->ac_list);
E 2
		h->last_val = c;
		if (h->np->chord_element != 0)
E 6
I 6
		c = h->hcl_np->cl_datum;
		rtn = pc_oct(c, &h->hcl_oct, &h->hcl_aclist);
		h->hcl_lastval = c;
		if (h->hcl_np->cl_chord != 0)
E 6
D 2
			Self->chordstat = TRUE;
		else
			Self->chordstat = FALSE;
E 2
I 2
			Player_stat |= P_CHORD;
E 2
	}
D 2
	if (Player_stat & P_STOP_SET) {	/* stop this player */
		Self->runstat = P_STOPPED;
		return(1.0);	/* return something safe */
	}
E 2
	if (Player_stat & P_REST_SET) {	/* play a rest */
D 6
 		Self->reststat = TRUE;
E 6
I 6
 		Self->P_reststat = TRUE;
E 6
		return(1.0);	/* return something safe */
	}
	if (Player_stat & P_EXPR_ERR) {	/* unknown note specification */
		fprintf(stderr, "Pitches: unknown note spec.:``%s''\n", c);
		return(1.0);
	}
D 6
	frequency = Scale[rtn] * pow(2.0, h->oct);
E 6
I 6
	frequency = Scale[rtn] * pow(2.0, h->hcl_oct);
E 6
	return(frequency);
D 7
}

/*
 * Pitch -	evaluate string as Pitch field
 * takes:	
 *	str -	pointer to Pitch string
 * returns:	
 *	pitch in Hz of evaluated string
 * side effects: 
 *	sets Player_stat
D 2
 * 		to P_HOLD_SET if expr == HOLDSTR
 * 		to P_STOP_SET if expr == STOPSTR
E 2
 * 		to P_REST_SET if expr == RESTR
 * notes:	
D 2
 *	Does not stop Player on STOPSTR.
 *	Returns 1.0 if expression == HOLDSTR, RESTR, or STOPSTR.
E 2
I 2
 *	Does not recognize Stop or Hold.
 *	Returns 1.0 if expression == RESTR
E 2
 */

double
Pitch(str)
	register char *str;
{
	float oct;
	register int pc;
	
D 2
	Player_stat &= ~P_HOLD_SET;
	if (!strcmp(HOLDSTR, str))
		Player_stat |= P_HOLD_SET;

E 2
	pc = pc_oct(str, &oct, NULL);

D 2
	if (Player_stat & (P_STOP_SET|P_REST_SET|P_EXPR_ERR|P_HOLD_SET) == 0)
E 2
I 2
	if (Player_stat & (P_REST_SET|P_EXPR_ERR) == 0)
E 2
		return(Scale[pc] * pow(2.0, (double) oct));
	else
		return(1.0);
}

/*
 * Octave -	evaluate string as Pitch field, return octave
 * takes:	
 *	str - pointer to Pitch string
 * returns:	
 *	octave number of evaluated string
 * side effects: 
 *	sets Player_stat
D 2
 * 		to P_HOLD_SET if expr == HOLDSTR
 * 		to P_STOP_SET if expr == STOPSTR
E 2
 * 		to P_REST_SET if expr == RESTR
 * notes:	
D 2
 *	Does not stop Player on STOPSTR.
 *	Returns 1.0 if expression == HOLDSTR, RESTR, or STOPSTR.
E 2
I 2
 *	Does not recognize Stop or Hold.
 *	Returns 1.0 if expression == RESTR.
E 2
 *	Returns -1.0 if no octave specified in string.
 */

double
Octave(str)
	register char *str;
{
	float oct = -1.0;

D 2
	Player_stat &= ~P_HOLD_SET;
	if (!strcmp(HOLDSTR, str))
		Player_stat |= P_HOLD_SET;

E 2
	(void) pc_oct(str, &oct, NULL);

D 2
	if (Player_stat & (P_STOP_SET|P_REST_SET|P_EXPR_ERR|P_HOLD_SET) == 0)
E 2
I 2
	if (Player_stat & (P_REST_SET|P_EXPR_ERR) == 0)
E 2
		return((double) oct);
	else
		return(1.0);
}

/*
 * Keys -	evaluate Pitch fields as piano key numbers
 * takes:	
 *	nl -	pointer to string of Pitch fields in cyclic list format
 * returns:	
 *	pitch in semitones above A0 of evaluated field
 * side effects:	
 *	Increments pointer to next expression field.
 * 	Sets Player_stat:
 * 		to P_HOLD_SET if expr == HOLDSTR
 * 		to P_STOP_SET if expr == STOPSTR
 * 		to P_REST_SET if expr == RESTR
I 5
 * 		to P_KILL_SET if expr == KILLSTR
E 5
 * notes:	
D 5
 *	May stop Player if expr == STOPSTR.
E 5
I 5
 *	Will stop Player if expr == STOPSTR.
 *	Will kill Player if expr == KILLSTR.
E 5
 *	Returns last value if HOLDSTR is set and does not increment
 *		pointer to next expr field.
 */

double
Keys(nl)
	register char *nl;
{
D 6
	struct noteheader *h;
E 6
I 6
	struct headcl_hcl *h;
E 6
	int pc;
	double pitch;
	char *c;

	h = getid(nl);
	_motive(h, nl);
D 2
skip:	if (nextnot(h) != 0)
		clr_ac(&h->ac_list);
	c = h->np->datum;
	Player_stat &= ~P_HOLD_SET;
	if (!strcmp(HOLDSTR, c)) {
		pc = pc_oct(h->last_val, &h->oct, &h->ac_list);
E 2
I 2
	Player_stat &= ~(P_STOP_SET|P_HOLD_SET|P_TIMESIG|P_KEYSIG
D 5
		|P_WRAP|P_MEAS|P_METRONOME|P_CHORD);
E 5
I 5
		|P_WRAP|P_MEAS|P_METRONOME|P_CHORD|P_KILL_SET);
E 5
	do {
		if (nextnot(h) != 0)
D 6
			clr_ac(&h->ac_list);
E 6
I 6
			clr_ac(&h->hcl_aclist);
E 6
D 3
	} while (clist_directive(h) != 0);
E 3
I 3
	} while (clist_direct(h) != 0);
E 3
D 5
	if (h->np->n_stop) {	/* stop this player */
E 5
I 5
D 6
	if (h->np->n_kill) {	/* kill this player */
E 6
I 6
	if (h->hcl_np->cl_kill) {	/* kill this player */
E 6
		Player_stat |= P_KILL_SET;
D 6
		Self->runstat = P_KILLED;
E 6
I 6
		Self->P_runstat = P_KILLED;
E 6
		return(1.0);
D 6
	} else if (h->np->n_stop) {	/* stop this player */
E 6
I 6
	} else if (h->hcl_np->cl_stop) {	/* stop this player */
E 6
E 5
		Player_stat |= P_STOP_SET;
D 6
		Self->runstat = P_STOPPED;
E 6
I 6
		Self->P_runstat = P_STOPPED;
E 6
		return(1.0);	/* return something safe */
	}
D 6
	else if (h->np->n_hold) {
		c = h->last_val;
		pc = pc_oct(c, &h->oct, &h->ac_list);
E 6
I 6
	else if (h->hcl_np->cl_hold) {
		c = h->hcl_lastval;
		pc = pc_oct(c, &h->hcl_oct, &h->hcl_aclist);
E 6
E 2
		Player_stat |= P_HOLD_SET;
	} else {
D 2
		if ((pc = pc_oct(c, &h->oct, &h->ac_list)) == -2)
			goto skip; /* skip key signature */
E 2
I 2
D 6
		c = h->np->datum;
		pc = pc_oct(c, &h->oct, &h->ac_list);
E 2
		h->last_val = c;
		if (h->np->chord_element != 0)
E 6
I 6
		c = h->hcl_np->cl_datum;
		pc = pc_oct(c, &h->hcl_oct, &h->hcl_aclist);
		h->hcl_lastval = c;
		if (h->hcl_np->cl_chord != 0)
E 6
D 2
			Self->chordstat = TRUE;
		else
			Self->chordstat = FALSE;
E 2
I 2
			Player_stat |= P_CHORD;
E 2
	}
D 2
	if (Player_stat & P_STOP_SET) {	/* stop this player */
		Self->runstat = P_STOPPED;
		return(1.0);	/* return something safe */
	}
E 2
	if (Player_stat & P_REST_SET) {
D 6
 		Self->reststat = TRUE;
E 6
I 6
 		Self->P_reststat = TRUE;
E 6
		return(1.0);	/* return something safe */
	}
	if (Player_stat & P_EXPR_ERR) {	/* unknown note specification */
D 2
		fprintf(stderr, "Keys: unknown note spec.:``%s''\n");
E 2
I 2
		fprintf(stderr, "Keys: unknown note spec.:``%s''\n", c);
E 2
		return(1.0);
	}
D 6
	pitch = pc + (PITCHES * (h->oct + 4.0));
E 6
I 6
	pitch = pc + (PITCHES * (h->hcl_oct + 4.0));
E 6
	return(pitch);
}

/*
 * Key -	evaluate Pitch string as semitone index
 * takes:	
 *	str -	pointer to Pitch string
 * returns:	
 *	pitch in semitones above A0 of evaluated field
 * side effects: 
 *	Sets Player_stat:
D 2
 * 		to P_HOLD_SET if expr == HOLDSTR
 * 		to P_STOP_SET if expr == STOPSTR
E 2
 * 		to P_REST_SET if expr == RESTR
 * notes:	
D 2
 *	Does not stop Player on STOPSTR.
 *	Returns 1.0 if expression == HOLDSTR, RESTR, or STOPSTR.
E 2
I 2
 *	Does not recognize Stop or Hold.
 *	Returns 1.0 if expression == RESTR
E 2
 */

double
Key(str)
	register char *str;
{
	float oct;
	register int pc = pc_oct(str, &oct, NULL);

D 2
	if (Player_stat & (P_STOP_SET|P_REST_SET|P_EXPR_ERR|P_HOLD_SET) == 0)
E 2
I 2
	if (Player_stat & P_REST_SET|P_EXPR_ERR == 0)
E 2
		return(pc + (PITCHES * (oct + 4.0)));
	else
		return(1.0);
E 7
}
E 1
