h43169
s 00009/00016/00022
d D 2.1 86/01/30 16:39:53 dgl 2 1
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00038/00000/00000
d D 1.1 85/11/06 12:38:36 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <carl/Player.h>

extern double Scale[];

double Octave(str)
D 2
	register char *str;
E 2
I 2
	register char *str;	/* string containing Pitch expression */
E 2
/*
D 2
 * Evaluate string as Pitch expression, return octave.
 * .TP
 * Takes:	
 * pointer to string containing Pitch expression.
 * .TP
 * Returns:	
 * octave number of evaluated expression.
 * .TP
 * Side effects: 
 * Sets Player_stat to P_REST_SET if expr == RESTR.
 * .TP
 * Notes:	
 * Does not recognize Stop, Kill, or Hold.
 * Returns 1.0 if expression == RESTR.
 * Returns -1.0 if no octave specified in string.
E 2
I 2
 * Evaluate string as \fBPitch\fP expression, return octave (if any).
 * .LP
 * Returns
 * piano octave number of evaluated expression.
 * Sets \fBPlayer_stat\fP to \fBP_REST_SET\fP 'if expression ==' \fBRESTR\fP, 
 * and returns 1.0.
 * Returns \-1.0 if no octave specified in string.
 * Does not recognize \fBStop\fP, \fBKill\fP, or \fBHold\fP.
E 2
 */
{
	float oct = -1.0;

	(void) pc_oct(str, &oct, NULL);

	if (Player_stat & (P_REST_SET|P_EXPR_ERR) == 0)
		return((double) oct);
	else
		return(1.0);
}
E 1
