h31288
s 00012/00011/00017
d D 2.1 86/01/30 16:35:28 dgl 2 1
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00028/00000/00000
d D 1.1 85/11/05 22:04:56 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */


#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <carl/Player.h>
#include "debug.h"

D 2
/*
 * Motive -	parse and install cyclic list string in symbol table
 * takes:
 * 	c -	cyclic list string address
 * side effects:
 * 	Parses cyclic list string into Finite State Automaton.
 * 	Places the FSA in a symbol table in two places:
 * 		- indexed by the cyclic list string address, and
 * 		- indexed by the cyclic list string label, if any.
 */
E 2

Motive(c)
D 2
	register char *c;
E 2
I 2
	register char *c;	/* cyclic list string address */
/*
 * Parse string as cyclic list and install in symbol table.
 * .LP
 * Parses cyclic list string into Finite State Automaton (FSA).
 * Places the FSA in the symbol table in two places:
 * (1)
 * indexed by the cyclic list string address, and
 * (2)
 * indexed by the cyclic list string label (if any) for "@" quoting.
 */
E 2
{
I 2
	extern struct headcl_hcl *newid();
E 2
	register struct headcl_hcl *h;

	h = newid(c);
	_motive(h, c);
}
E 1
