h48705
s 00017/00049/00048
d D 2.2 86/01/30 16:36:47 dgl 8 7
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00012/00012/00085
d D 2.1 85/10/26 23:41:50 dgl 7 6
c changed variable names.
e
s 00002/00000/00095
d D 1.5 85/10/14 15:49:26 dgl 6 5
c returns 0.0 on NULL.
e
s 00009/00003/00086
d D 1.4 85/10/11 11:51:26 dgl 5 3
c added Kill directive.
e
s 00009/00003/00086
d R 1.4 85/10/10 16:51:56 dgl 4 3
c Added ``Kill'' cyclic list directive.
e
s 00001/00001/00088
d D 1.3 85/09/30 13:45:23 dgl 3 2
c s/clist_directive/clist_direct/
e
s 00020/00021/00069
d D 1.2 85/03/13 22:54:21 dgl 2 1
c Overhaul of flag-setting system, also corrected
c handling of accidentals and directives.
e
s 00090/00000/00000
d D 1.1 84/12/21 12:01:25 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <carl/Player.h>

extern int exprerr;	/* from expr() in libfrm */

I 8
double Exprs(nl)
	register char *nl;	/* string of arithmetic expressions */
E 8
/*
D 8
 * Expr - 	evaluate string expression as cyclic list field
 * takes: 	
 *	str -	list element string
 * returns: 	
 *	value of expression
 * side effects:
 *	sets Player_stat:
 *		to P_HOLD_SET if expr == HOLDSTR
 *		to P_STOP_SET if expr == STOPSTR
 * notes:
 *	Does not stop Player on STOPSTR.
 *	Returns 1.0 if expression == HOLDSTR or STOPSTR.
E 8
I 8
 * Evaluate string as cyclic list of arithmetic expressions.
 * .LP
 * Returns value of evaluated field.
 * Sets \fBPlayer_stat\fP
 * .in +5
 * .nf
 * to \fBP_HOLD_SET\fP 'if expr ==' \fBHOLDSTR\fP,
 * to \fBP_STOP_SET\fP 'if expr ==' \fBSTOPSTR\fP,
 * to \fBP_KILL_SET\fP 'if expr ==' \fBKILLSTR\fP.
 * .in -5
 * .fi
 * Will stop Player 'if expr ==' \fBSTOPSTR\fP.
 * Will kill Player 'if expr ==' \fBKILLSTR\fP.
 * Returns previous value if \fBHOLDSTR\fP is scanned, and does not increment
 * 	pointer to next cyclic list field.
E 8
 */
D 8

double 
Expr(str) 
	register char *str; 
{
	register double rtn;

I 6
	if (str == NULL)
		return(0.0);
E 6
D 2
	Player_stat &= ~(P_HOLD_SET | P_STOP_SET);
	if (!strcmp(HOLDSTR, str)) {
		Player_stat |= P_HOLD_SET;
		return(1.0);
	}
	if (!strcmp(str, STOPSTR)) {
		Player_stat |= P_STOP_SET;		/* "stop" seen */
		return(1.0);
	}
E 2
	rtn = expr(str);
	if (exprerr)
		pexprerr("Expr", str, 0);
	return(rtn);
}

/*
 * Exprs -	evaluate cyclic list as expression fields
 * takes:	
 *	nl -	pointer to string of expression fields in cyclic list format
 * returns:	
 *	numerical value of evaluated field
 * side effects:	
 *	increments pointer to next expression field
 * 	sets Player_stat:
 * 		to P_HOLD_SET if expr == HOLDSTR
 * 		to P_STOP_SET if expr == STOPSTR
I 5
 * 		to P_KILL_SET if expr == KILLSTR
E 5
 * notes:	
D 5
 *	May stop Player if expr == STOPSTR.
E 5
I 5
 *	Will stop Player if expr == STOPSTR.
 *	Will kill Player if expr == KILLSTR.
E 5
 *	Returns last value if HOLDSTR is set and does not increment
 *		pointer to next expression field.
 */

double 
Exprs(nl)
	register char *nl;
E 8
{
D 2
	register double rtn;
E 2
I 2
	register double rtn = 0.0;
E 2
	register char *c;
D 7
	register struct noteheader *h = getid(nl);
E 7
I 7
	register struct headcl_hcl *h = getid(nl);
E 7

	_motive(h, nl);
D 2
	(void) nextnot(h);
E 2
I 2
	Player_stat &= ~(P_STOP_SET|P_HOLD_SET|P_TIMESIG|P_KEYSIG
D 5
		|P_WRAP|P_MEAS|P_METRONOME|P_CHORD);
E 5
I 5
		|P_WRAP|P_MEAS|P_METRONOME|P_CHORD|P_KILL_SET);
E 5
	do {
		if (nextnot(h) != 0)
D 7
			clr_ac(&h->ac_list);
E 7
I 7
			clr_ac(&h->hcl_aclist);
E 7
D 3
	} while (clist_directive(h) != 0);
E 3
I 3
	} while (clist_direct(h) != 0);
E 3
E 2
D 7
	c = h->np->datum;
D 2
	if (!strcmp(HOLDSTR, c)) {
		rtn = Expr(h->last_val);
E 2
I 2
D 5
	if (h->np->n_stop) {	/* stop this player */
E 5
I 5
	if (h->np->n_kill) {	/* kill this player */
E 7
I 7
	c = h->hcl_np->cl_datum;
	if (h->hcl_np->cl_kill) {	/* kill this player */
E 7
		Player_stat |= P_KILL_SET;
D 7
		Self->runstat = P_KILLED;
E 7
I 7
		Self->P_runstat = P_KILLED;
E 7
		return(1.0);
D 7
	} else if (h->np->n_stop) {	/* stop this player */
E 7
I 7
	} else if (h->hcl_np->cl_stop) {	/* stop this player */
E 7
E 5
		Player_stat |= P_STOP_SET;
D 7
		Self->runstat = P_STOPPED;
E 7
I 7
		Self->P_runstat = P_STOPPED;
E 7
		return(1.0);	/* return something safe */
	}
D 7
	else if (h->np->n_hold) {
		rtn = expr(h->last_val);
E 7
I 7
	else if (h->hcl_np->cl_hold) {
		rtn = expr(h->hcl_lastval);
E 7
		if (exprerr)
D 7
			pexprerr("Exprs", h->last_val, 0);
E 7
I 7
			pexprerr("Exprs", h->hcl_lastval, 0);
E 7
E 2
		Player_stat |= P_HOLD_SET;
	} else {
D 2
		rtn = Expr(c);
E 2
I 2
		rtn = expr(c);
		if (exprerr)
			pexprerr("Exprs", c, 0);
E 2
D 7
		h->last_val = c;
		if (h->np->chord_element != 0)
E 7
I 7
		h->hcl_lastval = c;
		if (h->hcl_np->cl_chord != 0)
E 7
D 2
			Self->chordstat = TRUE;
		else
			Self->chordstat = FALSE;
	}
	if (Player_stat & P_STOP_SET) {	/* stop this player */
		Self->runstat = P_STOPPED;
		return(1.0);	/* return something safe */
E 2
I 2
			Player_stat |= P_CHORD;
E 2
	}
	return(rtn);
}
E 1
