/* %M%	%I%	(CARL)	%G%	%U% */

#include <sys/types.h>
#include <carl/midi.h>
#include <carl/dx7.h>
#include <carl/mpu.h>

elapsed_time(fd)
	int fd;
{
	static	 long	elapsed_ticks;
	register long	tticks = Now * MPU_DEFAULT_TICS_PER_SEC + .5;
	register int	ticks = tticks - elapsed_ticks;
	register int	periods = ticks / MPU_CLOCK_PERIOD;
	register int	phase   = ticks % MPU_CLOCK_PERIOD;

	while(periods--)
		midi_out(fd, RT_TCIP);

	midi_out(fd, phase);
	elapsed_ticks = tticks;
}

/*
 * play_note -	emit MPU-401 code for note
 * takes:
 * 	P4 of parent as duration of note to play
 * 	P5 of parent as MIDI key index
 * 	P6 of parent as velocity of attack
 * 	P7 of parent as channel
 */

# define CRACK(flag, ac, av, flags, ign) while ((flag = crack(ac, av, flags, 1)) != NULL)

M_start()
{
	extern int arg_index;
	extern char *arg_option;
	int flag;

	CRACK(flag, Argc, Argv, "h", 1) {
		switch (flag) {
			case 'h':
			default:
				usage(0);
		}
	}
	Print_notes = NULL;
	SubstitutePname("play_note");
}

usage(ex)
{
fprintf(stderr, "%s%s%s%s",
"cmus2mpu: usage:\n",
"    cmus2mpu < cmusic_note_statements > mpu_code\n",
"where each note_statement is:\n",
"    note begin_time any_name duration key [[[velocity] channel] program];\n");
exit(ex);
}

M_ter()
{
	midi_out(1, 0);
	midi_out(1, 0xf9);
}

Player play_note()
{
	extern double timescale();
	Instance int sequence; 
	Instance u_char key, chan, prg;
	Instance double time;
	u_char vel;

	Kill_test(P_GE);
	if (sequence == 0) {
		key = atoi(Pi5);
		if (Hipn(Self, -1) >= 6)
			vel = atoi(Pi6);
		else
			vel = 64;
		if (Hipn(Self, -1) >= 7)
			chan = atoi(Pi7);
		else
			chan = 0;
		if (Hipn(Self, -1) >= 8) {
			prg = atoi(Pi8);
			elapsed_time(1);
			if (send_ch(1, CH_PRG, chan, prg, 0) != 0)
				Pexit(1);
		}
		elapsed_time(1);
		if (send_ch(1, CH_KEY_ON, chan, key, vel) != 0)
			Pexit(1);
		Wait_until(Abs_time() + atof(Pi4) - .001);
		sequence++;
	} else {
		elapsed_time(1);
		if (send_ch(1, CH_KEY_ON, chan, key, 0) != 0)
		    exit(1);
		Kill(Self);
	}
}

/*
 * double
 * timescale(Now)
 * {
 * 	static double start = 1.0, end = .5;
 * 	static double dur = 100.0;
 * 	double f = (Now - dur) / dur;
 * 
 * 	return((f * end + ((1.0 - f) * start)) * Now);
 * }
 */
