/*
 * commandline - demo program for crack()
 * Like wire.c, this program does no useful work other than to show off
 * the subroutine crack() to good advantage.  This program scans
 * 5 kinds of flag, and any number of filenames from the standard input
 * in a way that is easily adapatble to any programming task.
 */

# include <stdio.h>
# include <carl/carl.h>

main(argc, argv)
	char *argv[];
{
	char ch;
	int i;

	while ((ch = crack(argc, argv, "a|b|cdh", 0)) != NULL) {
	    switch (ch) {
		    case 'a':	/* this flag takes an expression */
			    printf("flag=%c, arg=%s, ", ch, arg_option);
			    printf("val=%g\n", sfexpr(arg_option, 1.0));
			    break;
		    case 'b':	/* this flag takes a simple string option */
			    printf("flag=%c, arg=%s\n", ch, arg_option);
			    break;
		    case 'c':	/* c and d are here handled together */
		    case 'd':
			    printf("flag=%c\n", ch);
			    break;
		    case 'h':	/* standard "help" flag */
			    usage(0);
		    default:
			    usage(1);
	    }
	}
	if (arg_index == argc)
		printf("no files\n");
	else
		for (i = arg_index; i < argc; i++)
			printf("file=%s\n", argv[i]);
}

usage(x)
{
	fprintf(stderr, "%s%s%s%s%s%s%s%s",
	"usage: commandline [flags] [files]\n",
	"\tflags:\n",
	"\t-a[optional arithmetic expression]\n",
	"\t-b[option]\n",
	"\t-c\n",
	"\t-d\n",
	"example: commandline -a2+2 -bfoo -c -d file1 file2 file3\n",
	"or: commandline -cd -a4K -bfred file1 file2 file3\n"
	);
	exit(x);
}
