#! /bin/csh -f -b

set TEMP = /tmp/sf$$
set SFSTAB = /carl/lib/sfstab
set BIN = /carl/bin

unset DEBUG
if ( ${?DEBUG} ) then
	foreach ARG ( ${argv} )
		switch ( ${ARG} )
			case -O:
				set OVERRIDE;
				shift;
				breaksw;
		endsw
	end
endif

if ( ${#argv} < 1 ) then
	echo ""
	echo "umountsf: (fatal) usage: umountsf csound_filesystem"
	echo "umountsf: STOP! DO NOT TOUCH THE DRIVE!"
	exit(1)
else
	set NAME = ${argv[1]}
endif

who i is | grep -s guest
if ( ${status} == 0 ) then
	echo ""
	echo "umountsf: (fatal) you can't run this as guest"
	echo "umountsf: STOP! DO NOT TOUCH THE DRIVE!"
	exit 1
endif

if ( ${?OVERRIDE} && ` whoami ` == "disk" ) then
	;
else
	if ( ` tty ` != "/dev/console" ) then
		echo ""
		echo "umountsf: (fatal) you must run this from the console"
		echo "umountsf: STOP! DO NOT TOUCH THE DRIVE!"
		exit(1)
	endif
endif

switch ( ${NAME} )
	case /snd1:
		set SEDSTR = "/snd1:/s/rw/xx/"
		set DISK = "up1"
		set PARTITION = "e"
		breaksw

	case /snd2:
		set SEDSTR = "/snd2:/s/rw/xx/"
		set DISK = "up1"
		set PARTITION = "e"
		breaksw

	case /snd3:
		set SEDSTR = "/snd3:/s/rw/xx/"
		set DISK = "up1"
		set PARTITION = "e"
		breaksw

	case /snd4:
		set SEDSTR = "/snd4:/s/rw/xx/"
		set DISK = "up1"
		set PARTITION = "e"
		breaksw

	case /snd5:
		set SEDSTR = "/snd5:/s/rw/xx/"
		set DISK = "up1"
		set PARTITION = "e"
		breaksw

	case /snd6:
		set SEDSTR = "/snd6:/s/rw/xx/"
		set DISK = "up1"
		set PARTITION = "e"
		breaksw

	case /snd7:
		set SEDSTR = "/snd7:/s/rw/xx/"
		set DISK = "up1"
		set PARTITION = "e"
		breaksw

	case /snd8:
		set SEDSTR = "/snd8:/s/rw/xx/"
		set DISK = "up1"
		set PARTITION = "e"
		breaksw

	case /snd9:
		set SEDSTR = "/snd9:/s/rw/xx/"
		set DISK = "up1"
		set PARTITION = "e"
		breaksw

	case /snd10:
		set SEDSTR = "/snd10:/s/rw/xx/"
		set DISK = "up1"
		set PARTITION = "e"
		breaksw


	case up1:
		set DISK = "up1";
		set PARTITION = "e"
		breaksw;

	default:
		echo ""
		echo "umountsf: (fatal) don't know about ${NAME}"
		echo "umountsf: STOP! DO NOT TOUCH THE DRIVE!"
		exit(1)
endsw

# unmount all partitions on up1
foreach PART ( `/etc/mount | awk '{ if ( $1 ~ /up1[a-z]/ ) print "/dev/"$1 }'`)
	echo "umountsf: umounting ${PART}"
	/etc/umount ${PART}
	if ( ${status} != 0 ) then
		echo ""
		echo "umountsf: (fatal) can't umount ${PART}"
		echo "umountsf: STOP! DO NOT TOUCH THE DRIVE!"
		exit(1)
	endif
end

# if ( ${NAME} != up1 ) then
#	${BIN}/locksf ${NAME} changing packs
#	if (${status} != 0) then
#		echo ""
#		echo "umountsf: (fatal) locksf failed on ${NAME}"
#		echo "umountsf: STOP! DO NOT TOUCH THE DRIVE!"
#		exit(1)
#	endif
# endif

if ( ${NAME} != up1 ) then
	/bin/sed ${SEDSTR} ${SFSTAB} > ${TEMP}
	if ( ${status} != 0 ) then
		echo ""
		echo "umountsf: (fatal) sed of ${SFSTAB} failed"
		echo "umountsf: STOP! DO NOT TOUCH THE DRIVE!"
		${BIN}/unlocksf ${NAME}
		exit(1)
	endif
	cp ${TEMP} ${SFSTAB}
	if ( ${status} != 0 ) then
		echo ""
		echo "umountsf: (fatal) mv of ${SFSTAB} failed"
		echo "umountsf: STOP! DO NOT TOUCH THE DRIVE!"
		${BIN}/unlocksf ${NAME}
		exit(1)
	endif
	/etc/chown disk ${SFSTAB}
endif


# fix FSTAB; don't bomb out if this disk isn't in it though
grep -s ${DISK}${PARTITION} /etc/fstab
if ( $status != 0 ) then
	echo ""
	echo "umountsf: STOP! DO NOT TOUCH THE DRIVE!"
	echo "umountsf: (warning) ${DISK}${PARTITION} not in fstab"
	echo "umountsf: please notify a system maintenance person"

else
	grep -s ${NAME} /etc/fstab
	if ( $status != 0 ) then
		echo ""
		echo "umountsf: STOP! DO NOT TOUCH THE DRIVE!"
		echo "umountsf: (warning) ${NAME} not in fstab"
		echo "umountsf: please notify a system maintenance person"
	else
		# turn off all partitions
		onintr -
		/bin/sed -e "/${DISK}/s/:rw:/:xx:/" /etc/fstab >! ${TEMP}
		cp ${TEMP} /etc/fstab
		onintr
	endif
endif

if ( ${NAME} != up1 ) then
	# this writes a lock file in the unmounted directory
	if ( ! -e ${NAME}/MASTERLOCK ) then
		echo ${NAME} is offline > ${NAME}/MASTERLOCK
	endif
endif

rm -f ${TEMP}
