h62173
s 00339/00000/00000
d D 1.1 84/07/25 14:31:57 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>

/*
 * sopensf - system version of csound file open.
 * Arguments:
 * 	name : filename spec, can be partial name
 * 	mode : string of following
 * 		r 	read access
 * 		w 	write access
 * 		rw 	fully buffered read/write access
 * 		[r|w] F cause sdf file to be updated after each write
 * 	sfd : sound file descriptor
 * 		if NULL, use name to determine file
 * 		if !NULL, use filename on sfd to determine file and
 * 			if creating file (i.e., mode includes "w" and
 * 			file doesn't exist) use attributes of the sdf
 * 			to configure the file for nc, ns, fs, etc.
 * 			The new sfd will NOT have a pointer to the 
 * 			same disk block (if any) as the sfd passed as argument.
 * 
 * Actions:
 * lock system
 * get filename either from name or sdf
 * if writing,
 *     if not also reading,
 * 	  check sfstab to determine if writing is allowed on that device
 * 	  sfd must not be NULL, new file will be made from this sfd,
 * 	      which can have been created by e.g., sfoargs().
 * 	  unlink old file, if any (unlink barfs if file is busy)
 * 	  create new sfd from one passed as argument.
 *     if also reading,
 * 	  barf if file busy
 * 	  if it doesn't exist, 
 * 	      create new sfd from one passed as argument.
 * else it must be readonly
 *     lookup file, complain if not there.
 * 
 * We should have a valid sfd by now, check it.
 * open raw device,
 * zero the buffer pointer
 * mark sfd open for business, not at eof, set packing mode
 * write updated sfd
 * link on bidirectional linked list of open files
 * catch interrupts
 * unlock filesystem
 * return sfd
 */


int     sferror;		/* global error status word */
extern int     sfbufsiz;	/* from getsfbuf */
extern char *index();

struct sndesc  *
sopensf (name, mode, sfd)
	char   *name;
	char   *mode;
	struct sndesc  *sfd;
{
	int     quitit ();
	struct sndesc  *newsf (), *rsfd = NULL, *setsfd ();
	struct sfstab  *sfs,
	               *dirinfo ();
	char   *sfname = NULL,
	       *getsfn (), *getsfile ();
	struct sndesc  *accesf ();
	int     rw = 0;

 /* rw for sound system owner and disk group, read for others */
	(void) umask (~(0664));

	if (index (mode, 'r') != NULL)
		rw |= SFREAD;
	if (index (mode, 'w'))
		rw |= SFWRITE;
	if (index (mode, 'F'))
		rw |= SFFLUSH;
	if (name != NULL)
		sfname = name;
	else
		if (sfd != NULL)
			sfname = sfd -> sfn;
		else
			return (NULL);
	sfname = getsfn (sfname, 0);

 /* get status of specified device */
	if ((sfs = dirinfo (sfname)) == NULL) {
		fprintf (stderr, "sopensf: error reading %s\n", SFSTAB);
		sferror = -1;
		goto errexit;
	}
	if (index (sfs -> devmode, 'x')) {/* offline? */
		fprintf (stderr, "sopensf: %s disabled\n", sfs -> sdfdir);
		sferror = -1;
		goto errexit;
	}

 /* disable interrupts until the open is complete */
	ignall ();		/* ignore all interrupts in sopensf() */

	if (rw & SFWRITE) {
		if (!index (sfs -> devmode, 'w')) {
			fprintf (stderr, "sopensf: %s writing disabled\n", 
				sfs -> sdfdir);
			sferror = -1;
			goto errexit;
		}
		if (!(rw & SFREAD)) {/* writeonly, mode == only 'w' */
		/* ok to delete old file if it is not in use */
			if (nameok (sfname)) {
				sferror = -1;
				goto errexit;
			}
			if (sfd == NULL) {
			    fprintf (stderr, 
				"sopensf: can't create file from NULL sfd!\n");
			    sferror = -1;
			    goto errexit;
			}
			if (dpermis (sfname) != 0) {
			    fprintf (stderr, 
			       "sopensf: no directory permission for file %s\n",
				    sfname);
			    sferror = -1;
				goto errexit;
			}
			if (unlinksf (sfname) != 0) {
				/* returns 0 on no file */
				sferror = -1;
				goto errexit;
			}
			sfd = setsfd (sfd, "f", sfname);
			if ((sfd = newsf (sfd)) == NULL) {
				sferror = -1;
				goto errexit;
			}
		}
		else	/* readwrite, mode == "rw" , look for existing file. */
			if ((sfd = accesf (sfname)) != NULL) {
				/* old file found */
				if (sfd -> rw & SFOPEN) {
				/* check here for file busy */
				    fprintf (stderr, "sopensf: file in use.\n");
				    sferror = -1;
				    goto errexit;
				}
			}
			else
				if (sferror) {
				    fprintf (stderr, 
					"sopensf: access error on file %s\n", 
					sfname);
				    goto errexit;
				}
				else {/* create new file from sfd */
					if (sfd == NULL) {
					    fprintf (stderr, "sopensf: can't create file from NULL sfd\n");
					    sferror = -1;
					    goto errexit;
					}
					sfd = setsfd (sfd, "f", sfname);
					if ((sfd = newsf (sfd)) == NULL) {
						sferror = -1;
						goto errexit;
					}
				}
	}
	else
		if (rw & SFREAD) {/* readonly */
			if ((sfd = accesf (sfname)) == NULL) {
				sferror = SFNOFILE;
				goto errexit;
			}
		}
 /* we should have something by now */
	if (checksfd (sfd)) {
		fprintf (stderr, "sopensf: bad sound file descriptor.\n");
		sferror = -1;
		goto errexit;
	}
	sfd -> sb = NULL;
 /* open raw device */
	if ((sfd -> fid = getrfid (sfs, rw)) < 0) {
		perror ("sopensf");
		fprintf (stderr, "sopensf: can't open %s\n", sfs -> snddev);
		sferror = -1;
		goto errexit;
	}
 /* mark the sound file open */
	sfd -> rw = (SFOPEN | rw);
	sfd -> eof = FALSE;	/* mark file not at end */
	sfd -> ssize = sfd -> pm == PM16BIT ? sizeof (short) : sizeof (float);
	if (sfbufsiz == 0)
		sfd -> bufsiz = sfs -> bsize;/* bytes per buffer */
	else
		sfd -> bufsiz = sfbufsiz;/* use buffer size override */
	sfd -> blksiz = sfs -> bpblock;
	sfd -> spid = getpid ();/* say who has it open */
	rsfd = sfd;
	if (wsdf ((FILE *) NULL, rsfd) < 0) {/* write out opened sfd */
		sferror = IOER;
		return (NULL);
	}
	linksfd (sfd);		/* link sfd to doubly linked list of open
				   files */
errexit: 			/* a goto here means rsfd will be NULL */
	catchall (quitit);	/* setup to catch interrupts */
	return (rsfd);
}

nameok (name)
char   *name;
{
	char   *rindex (), *n;

	if (name == NULL)
		return (-1);
	n = rindex (name, '/');
	if (n != NULL) {
		if (*(n+1) == '.') {
		    fprintf (stderr,
			"sopensf: do not start filename with `.'\n");
		    return(-1);
		}
		if (strlen (n+1) + strlen (SDFEXT) > UMAXNLEN) {
		    fprintf (stderr, 
			"sopensf: filename %s too long, maximum length = %d\n",
				n, UMAXNLEN - strlen (SDFEXT));
		    return(-1);
		}
	}
	if (badchrs (name)) {
		fprintf (stderr, "sopensf: garbage characters in filename\n");
		return(-1);
	}
	if (!strcmp (n + 1, ".") || !strcmp (n + 1, "..")) {
		fprintf (stderr, "sopensf: bad filename: %s\n", name);
		return(-1);
	}
	return (0);
}

char   *hitlist = " !?\"&~\177";

badchrs (name)
char   *name;
{
	while (*name != NULL) {
		if (*name < 32)
			return (1);
		if (index (hitlist, *name))
			return (1);
		name++;
	}
	return (0);
}

getrfid (sfs, rw)
	struct sfstab  *sfs;
	int     rw;
{
	static struct rawdevio {
		int     rmode;
		int     rfid;
		int     wfid;
		int     rwfid;
	}                       rdevstat[NSFSYS];
	register int    rawfid;

 /* is this raw device open in the mode we want already? */
	if (rdevstat[sfs -> rdevn].rmode != rw) {
	/* we must open it */
		if ((rawfid = open (sfs -> snddev, rw - 1)) < 0)
			return (rawfid);
		rdevstat[sfs -> rdevn].rmode = rw;/* save r/w status */
		if (rw == SFREAD)
			rdevstat[sfs -> rdevn].rfid = rawfid;
		if (rw == SFWRITE)
			rdevstat[sfs -> rdevn].wfid = rawfid;
		if (rw == (SFREAD | SFWRITE))
			rdevstat[sfs -> rdevn].rwfid = rawfid;
	}
	else {			/* exitsts, get it */
		if (rw == SFREAD)
			rawfid = rdevstat[sfs -> rdevn].rfid;
		if (rw == SFWRITE)
			rawfid = rdevstat[sfs -> rdevn].wfid;
		if (rw == (SFREAD | SFWRITE))
			rawfid = rdevstat[sfs -> rdevn].rwfid;
	}
	return (rawfid);
}

/* 
 * sopensf - opens the named sound file.  
 * name is the body of a sound file name, without any path prefix, or suffix. 
 * mode may be any of "r", "w" or "t", corresponding to:
 * read, write and realtime.  
 * "r" and "w" may be combined for readwrite mode.  Use this mode for
 * all situations where writing is not by units of a page of bytes (1024 bytes
 * on 3BSD and 4BSD, 512 on straight Version 7).
 * "t" causes sopensf to make sure that the description of the file being 
 * accessed is realtime.  An error message is generated if the file
 * is not.  This is a useful check by programs that can
 * deal with realtime files only.
 * It is an error to open a file for reading or readwriting with "t" 
 * if it is not already a realtime file.  This is just a further check on
 * the sfd handed to sopensf which you can utilize.
 * Please note that there are two protocols for naming a file depending
 * on whether you are reading or writing:
 *	If only "r", the name arg. is used, sfd is NULL;
 *	If only "w", the name arg. is NULL, the sfd->sfn field specifies
 *		the name and all other aspects of the file to be created
 *		or overwritten.
 *	If "rw", the sfd->sfn field specifies the name unless the sfd == NULL,
 *		in which case the name arg. is used to get the file"s
 *		existing sound descriptor file, which is subsequently used.
 * Disposition of read/write is: 
 *    If only "r", open file for read, if it exists, error if it doesn"t.
 *    If "w" and not "r", delete any existing non-busy file of same name, 
 *    create new one, else if busy, error.  
 *    If "r" and "w", don"t delete existing file, error if busy, open it for 
 *    reading and writing.  If file not found, create it from sfd.
 * When reading, or readwriting a file, the values 
 * found in the file"s sound descriptor 
 * file control file format.  
 * When just writing a file, its sound descriptor file will be created using
 * the sfd argument to sopensf.  The descriptor file will only be written
 * when the new file is closed with sclosesf().
 * If readwriting, and an existing file can't be found, the file
 * will be created using the sfd argument, if one is supplied, else error.  
 * Note that this means that in these two cases, (namely, write and readwrite
 * to a nonexistant file) the name argument to sopensf
 * is not used, the name field is gotten from the supplied sfd.
 * Only in these two cases is it therefor an error for sfd to be NULL.  
 */
E 1
