/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/sndio.h>
#define BUFSIZE	4096
#define min(a,b) ((a)<(b)?(a):(b))

extern int sferror;
extern long filsfb();
extern char *chans;
extern char *chanspec;
extern int otty;

stos(sfd, begin, end)
	CSNDFILE *sfd; long begin, end;
{
	register long i;
	register short *sp;
	register int nsib, nc;
	int ss_fn = 0, ss_fpos = 0;
	short buffer[BUFSIZE / sizeof(short)];

	if (getsfbuf(sfd))
		{ sferror = -1; return(-1); }
	sp = sfd->sb;
	nc = sfd->nc;
	nsib = sfd->nsib;
	begin *= nc;	/* convert to sample frames */
	end *= nc;	/* convert to sample frames */
	begin = begin > 0 ? begin : 0;
	end = min(sfd->fs, end);

	for (i = begin; i < end; i++) {
		register long x;
		register long block; 
		register int bs = BUFSIZE / sizeof(short);

		if (!chans[i%nc]) continue;
		block = i / nsib;			
		if (block != sfd->secptr) 
		    if ((sfd->secptr = filsfb(sfd, block)) < 0)
			    { sferror = SFBNDER; break; }
		x = i % nsib;	/* get samp in buf */

		if (otty) 
			printf("%d\t%d\n", i, *(sp+x));
		else {
			*(buffer + ss_fpos++) = (*(sp+x));
			if (ss_fpos >= bs) {
				if ((ss_fn = write(1, (char *) buffer, BUFSIZE))
				    <=0) {
					sferror++;
					break;
				}
				ss_fpos = 0;
			}
		}
	}
	if (!otty) 
		if (ss_fpos > 0) {
			if ((ss_fn = write(1, (char *) buffer, 
			  ss_fpos*sizeof(short)))
			    <= 0)
				sferror++;
			ss_fpos = 0;
		}
	free((char *) buffer);	
	return(sferror);
}
