h46500
s 00067/00000/00000
d D 1.1 84/07/25 14:31:16 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/sndio.h>
#define BUFSIZE	4096
#define min(a,b) ((a)<(b)?(a):(b))

extern int sferror;
extern long filsfb();
extern char *chans;	/* from setchan() */
extern char *chanspec;
extern int otty;

ftof(sfd, begin, end)
	CSNDFILE *sfd; long begin, end;
{
	register long i;
	register float *fp;
	register int nsib, nc;
	int ff_fn = 0, ff_fpos = 0;
	float buffer[BUFSIZE / sizeof(float)];

	if (getsfbuf(sfd))
		{ sferror = -1; return(-1); }
	fp = sfd->fb;
	nsib = sfd->nsib;
	nc = sfd->nc;
	begin *= nc;	/* convert to sample frames */
	end *= nc;	/* convert to sample frames */
	begin = begin > 0 ? begin : 0;
	end = min(sfd->fs, end);

	for (i = begin; i < end; i++) {
		register long x;
		register long block; 
		register int bs = BUFSIZE / sizeof(float);

		if (!chans[i%nc]) continue;
		block = i / nsib;			
		if (block != sfd->secptr) 
		    if ((sfd->secptr = filsfb(sfd, block)) < 0)
			    { sferror = SFBNDER; break; }
		x = i % nsib;	/* get samp in buf */

		if (otty) 
			printf("%d\t%f\n", i, *(fp+x));
		else {
			*(buffer + ff_fpos++) = (*(fp+x));
			if (ff_fpos >= bs) {
				if ((ff_fn = write(1, (char *) buffer, BUFSIZE))
				    <=0) {
					sferror++;
					break;
				}
				ff_fpos = 0;
			}
		}
	}
	if (!otty) 
		if (ff_fpos > 0) {
			if ((ff_fn = write(1, (char *)buffer, 
			  ff_fpos*sizeof(float)))
			    <= 0)
				sferror++;
			ff_fpos = 0;
		}
	return(sferror);
}
E 1
