/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <math.h>

#define NBIN 16
int bin[NBIN];
float thresh[NBIN];

inihist()
{
	register int i;
	for(i=0; i<NBIN; i++) 
		thresh[i] = pow(2.0, (float) -i );
	thresh[NBIN-1] = -0.000001;
}

int nsamp = 0;
double dc = 0.0, rms = 0.0, peak = 0.0;

hist(buf, ns) 
	float *buf; long ns;
{
	register int i, j;
	register float input; 
	register double absin, abspk;

	for (i = 0; i < ns; i++) {
		input = *(buf+i);
		dc += input;
		rms += input * input;
		absin = input>0.0 ? input : -input;
		abspk = peak>0.0 ? peak : -peak;
		if (absin > abspk ) 
			peak = input;
		for (j=NBIN-1; j>=0; j--)
			if (absin < thresh[j] ) { 
				bin[j+1]++; 
				break; 
			}
		}
	nsamp += ns;
}

endhist()
{
	register int i, j, max; 

	for (max=i=0; i<NBIN; i++) 
		if (bin[i] > max) 
			max = bin[i];

	for (i=0; i<NBIN; i++) {
		printf("> %8.5f (= %6.1fdB) = %6d", thresh[i],
			20.*log10(thresh[i]>0.0?thresh[i]:1.e-6), bin[i]);
		printf("|");
		if (max > 0)
			for (j=0; j < (int) 40.0*bin[i]/max; j++) 
				printf("*");
		printf("\n");
	}
	if (nsamp > 0) {
		dc /= nsamp;
		rms /= nsamp;
	} else
		dc = peak = rms = 1.e-6;
	if(dc == 0.0)
		dc = 1.e-6;
	if(peak == 0.0)
		peak = 1.e-6;
	if(rms == 0.0)
		rms = 1.e-6;
	printf("Mean = %f (= %.1fdB)\n", dc, 20.0*log10(dc>0.0?dc:-dc));
	printf("Peak = %f (= %.1fdB)\n", peak, 20.0*log10(peak>0.0?peak:-peak));
	printf("RMS = %f (= %.1fdB)\n", sqrt(rms), 10.0*log10(rms));
	printf("%d samples\n", nsamp);
}
