/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>
#include <sys/time.h>
#include <syslog.h>
#include <sys/file.h>

#define NCYLCK 1
#define PLIST 2
#define ZAPFREE 4
#define SDFRECK 010
#define BOOT 080
#define PARTIAL (FALSE)
#define FALSE 0
#define TRUE 1


int justnames;
int ferr=0;
int autopilot=0;
int boot = 0;
int verbose=1;
int force=NOFORCE; 
char sfdevice[32];
char *alloc;

extern int sflockmsg;

main(argc, argv)
	int argc; char *argv[];
{
	extern char *strcpy();
	extern long zapfree();
	struct sfstab *dirinfo(), *sfs;
	struct dskblk *head, *sfrdfre();
	int flags=NCYLCK, i=0;
	char *index();
	char *getsfile();

	if (argc == 1) 
		sfckhelp();

	sfsetiname(argv[0]);


	if (argc > 1)
		flags = 0;  	/* turn off preset flags */
	setsfile((char *) NULL);		/* preset device to check */

	for (i = 1 ; argc > 1; argc--, i++)
		{
		if (!index(argv[i], '-')) break;
		switch (argv[i][1])
			{
			case 'h':
			    sfckhelp();	/* which exits */
			case 'd':
			    (void) strcpy(sfdevice, &argv[i][2]);
			    break;
			case 'n':
			    flags |= NCYLCK;
			    verbose++;
			    break;
			case 'p':
			    flags |= PLIST;
			    break;
			case 'z':
			    flags |= ZAPFREE;
			    break;
			case 'f':
			    flags |= SDFRECK;
			    break;
			case 'A':
			    flags |= SDFRECK|ZAPFREE|NCYLCK;
			    break;
			case 'y':
			    autopilot++;
			    break;
			case 'v':
			    verbose++;
			    break;
			case 'B':
			    flags |= SDFRECK|ZAPFREE|NCYLCK; 
			    autopilot++;
			    boot++;
			    verbose=0;
			    break;
			case 'N':
			    justnames = 1;
			    break;
			}
		}

	if (argc > 1) 
		(void) strcpy(sfdevice, argv[i]);
	if (strlen(sfdevice))	/* other than default has been selected */
		setsfile((char *) sfdevice);
	else			/* use default */
		{
		char *tmp = getsfile((char *) NULL);
		(void) strcpy(sfdevice,tmp);
		free(tmp);
		}

	ferr = 0;

	alloc = getsfile(ALLOCNAME);
	if ((sfs = dirinfo(sfdevice)) == NULL) {
		fprintf(stderr, "dirinfo failed on %s\n", sfdevice);
		exit(++ferr);
	}

	/* masterlock system if doing consistency checks */
	if (flags & (SDFRECK|ZAPFREE)) {
		if (mlock(sfs->lkdev, 
			"csound i/o temporarily blocked by sfck.", 
				boot) != 0)
		    exit(++ferr);
	}

	if (boot || ingroup(SUPERGROUP)==1) 
	    force = FORCE; /* only superusers can run when masterlocked */
	else
	if (flags & ~(PLIST | NCYLCK)) {
		/* these are ok to run without being in the SUPERGROUP */
		fprintf(stderr, "sfck: Sorry, you are not a superuser.\n");
		exit(1);
	}

	if (nothere(alloc) || flags & SDFRECK) {
		char errstr[128]; 
		if (boot) {
			/* force rebuilding free list */
			if (access(alloc, F_OK) == 0)
				if (unlink(alloc) != 0) {
					perror("sfck: unlink");
					exit(++ferr);
				}
		} else {
			if (nothere(alloc)) {
			    (void) sprintf(errstr, 
				"sfck: %s not found.", alloc);
			    fprintf(stderr, "%s  Regenerating it...\n", errstr);
			    syslog(LOG_CRIT, errstr);
			}
		}
		if (regenfree(alloc) != 0)
			exit(1);
	}

	if (flags & ZAPFREE)
		{
		long hits;
		head = sfrdfre(sfdevice);
		hits = zapfree(head);
		if (hits < 0) ferr++;
		if (hits > 0) 
			fprintf(stderr, "Free list zapped.\n");
		if (wmflist(hits, head, alloc)) 
			ferr = 0;
		}

	if (flags & NCYLCK) {
		if (ncylck(sfrdfre(sfdevice), sfdevice, verbose)) { 
			fprintf(stderr, "sfck: %s free list contaminated.\n",
				sfdevice); 
			syslog(LOG_CRIT, "sfck: %s free list contaminated.", 
				sfdevice);
			ferr++; 
		}
	}

	if (flags & PLIST)  
		plist(sfrdfre(alloc));

	if (flags & (SDFRECK|ZAPFREE)) {
		if (!boot)
		    if (munlock(sfs->lkdev) != 0)
			exit(++ferr);
	}

	exit(ferr);
}

/* does the file exist? */
nothere(file)
	char *file;
{
    int rtn;
    if (!access(file, 0)) 
	rtn=0;	/* file exists, to home */
    else
	rtn++;
    return(rtn);
}

sfckhelp()
{
    printf("sfck: usage:\n%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s",
    "sfck [flags] [device]\n",
    " device (at CARL):  /snd  (default) or  /snd1  etc.\n",
    " flags:\n",
    " f = check connectivity between disk free list and .sdf files\n",
    " z = zap the free list (you must be a member of the disk group)\n",
    " n = check and print out cylinder usage statistics\n",
    " F = check connectivity between sound file directory and .sdf files\n",
    " A = do all the above at once, to fix a broken file system.\n",
    " p = pretty-print the disk free list file\n",
    " y = answer \"yes\" to everything sfck wants to do\n",
    " v = verbose\n",
    " B = boot; use this flag when cleaning system at boot time\n",
    "If you are not a wizard sfck only reports what it would do,\n",
    "and does not actually do anything.\n");
    exit(0);
}
