/* %M%	%I%	(CARL)	%G%	%U% */
/* ncylck - numeric check of free list continuity. */
#include <stdio.h>
#include <carl/libsf.h>
#include <syslog.h>

ncylck(listp, sfdevice, verbose)	/* Check # of cylinders */
    	struct dskblk *listp;
	char *sfdevice;
	int verbose;
{
    struct dskblk *dp;
    struct sfstab *sfs, *dirinfo();
    long maxcyls;
    int err = 0;
    long tcyls=0, ucyls=0, ncyls=0, acyls=0, fcyls=0, bigUblk=0, bigNblk=0;
    sfs = dirinfo(sfdevice);
    maxcyls = sfs->devlen;

    for (dp = listp; dp->flag != EOLIST; dp = dp->next)
	{
	switch (dp->flag)
	    {
	    case USED :		ucyls += dp->len; 
				if (dp->len > bigUblk) bigUblk = dp->len;
				break;
	    case UNUSED :	ncyls += dp->len; 
				if (dp->len > bigNblk) bigNblk = dp->len;
				break;
	    case ALLOCATED :	acyls += dp->len; break;
	    case FREED :	fcyls += dp->len; break;
	    default:		err++;
	    }
	if ((dp->next->flag != EOLIST)&&((dp->base + dp->len)!= dp->next->base))
	    {
	    fprintf(stderr, "block size misfit:\n");
	    fprintf(stderr, "flag base len ctime    seq name\n");
	    fprintf(stderr, "%c%5D%5D   %D%5D %s\n",
		dp->flag, dp->base, dp->len, dp->cd, dp->seq, dp->dfn);
	    syslog(LOG_CRIT, "sfck: block size misfit on %s", sfdevice);
	    err++;
	    }
	tcyls += dp->len;
	}
    if (verbose)
	{
	printf("%7s%6s%5s%8s%7s%9s%8s%6s\n", 
		"maxcyl","total","used","bigused", "unused","bignused",
		"alloced","freed");
	printf("%7D%6D%5D%8D%7D%9D%8D%6D\n",
		maxcyls, tcyls, ucyls, bigUblk, ncyls, bigNblk, acyls, 
		fcyls);
	}
    if (tcyls != maxcyls) err++;
    return(err);
}
