h44515
s 00159/00000/00000
d D 1.1 84/07/25 14:29:56 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
/* cc sdc.c -lsf -o sdc */
#include <stdio.h>
#include <carl/libsf.h>

#define LLEN 100

long    ncyl;
int     longformat = 0;

struct entry {
	char    stat;
	int     start;
	int     len;
	int     no;
	int     me;
	char    fn[30];
}              *mp;

main (argc, argv)
	int     argc;
	char   *argv[];
{
	extern char    *calloc (), *strcpy (), *strcat ();
	struct sfstab  *dirinfo ();
	char    dev[LLEN],
	        user[LLEN],
	       *index (), *getsfile (), *ptr;

	setsfile ((char *) NULL);
	(void) strcpy (dev, getsfile ((char *) NULL));
	if (getpw (getuid (), user) != 0) {
		fprintf (stderr, "sdc: no such user: %s\n", user);
		exit (1);
	}
	*index (user, ':') = '\0';
	ptr = index (user, '\0');
	for (; ptr >= user; ptr--)
		*(ptr + 1) = *ptr;
	user[0] = '/';
	if (argc == 2) {
		if (*argv[1] != '/') {
			fprintf (stderr, 
			    "sdc: argument must begin with slash (/)\n");
			exit (-1);
		}
		if (!strncmp (argv[1], "/snd", 4)) {
			(void) strcpy (dev, argv[1]);
			if (index ((dev + 1), '/')) {
				*index ((dev + 1), '/') = '\0';
				(void) strcpy (user, index((argv[1] + 1), '/'));
			}
		}
		else
			(void) strcpy (user, argv[1]);
	}
	ncyl = dirinfo (dev) -> devlen;
	mp = (struct entry *) calloc ((unsigned) ncyl, 
		(unsigned) sizeof (struct entry));
	makemap (mp, ncyl, dev, user);
}

makemap (map, Ncyl, dev, user)
int     Ncyl;
struct entry    map[];
char   *dev,
       *user;
{
	char    c,
	        line[LLEN],
	        junk[LLEN],
	        owner[LLEN];
	char   *index (), tmp[128];
	int     i,
	        st,
	        le,
	        n = 0,
	        j,
	        ulen,
	        usage = 0;
	FILE * fp;
	(void) strcpy (tmp, dev);
	(void) strcat (tmp, "/dskcyls");
	if ((fp = fopen (tmp, "r")) == NULL) {
		fprintf (stderr, "sdc: can't open %s\n", tmp);
		exit (-1);
	}

	(void) strcpy (tmp, dev);
	(void) strcat (tmp, user);
	ulen = strlen (tmp);
	while (fgets (line, LLEN, fp) != NULL) {
		(void) sscanf (line, 
			"%c	%d	%d	%d	%s	%s", 
			&c, &st, &le, &j, junk, owner);
		if (c == 'u')
			n++;
		for (i = st; i < st + le; i++) {
			map[i].stat = c;
			map[i].start = st;
			map[i].len = le;
			map[i].no = n;
			if (!strncmp (owner, tmp, ulen))
				map[i].me = 1;
			(void) strcpy (map[i].fn, &owner[ulen + 1]);
		}
	}
	printf ("       Soundfile Cylinder Usage Map: %s%s\n", dev, user);
	printf ("       (.=empty; a=allocated; u=used)\n");
	printf ("[Cyl]  (user's own files: *,+=used; A=allocated)\n");
	printf ("       ");
	for (i = 0; i < 5; i++)
		printf ("|---------");
	for (i = 0; i < Ncyl; i++) {
		if (!(i % 50))
			printf ("\n[%3d]: ", i);
		if (map[i].stat == 'n') {
			printf (".");
			continue;
		}
		if (map[i].stat == 'a') {
			if (map[i].me)
				printf ("A");
			else
				printf ("a");
			continue;
		}
		if (map[i].stat == 'u') {
			if (map[i].me) {
				printf ("%c", (map[i].no) % 2 + '*');
				usage++;
			}
			else
				printf ("u");
			continue;
		}
		printf ("?");
	}
	printf ("\n");
	printf ("       ");
	for (i = 0; i < 5; i++)
		printf ("|---------");
	st = -1;
	n = 0;
	printf ("\n[start, length]-name:");
	for (i = 0; i < Ncyl; i++) {
		if ((map[i].me && map[i].start != st) && map[i].stat == 'u') {
			if (longformat) {
				if (!((n++) % 4))
					printf ("\n");
				printf ("[%3d, %2d]-%-8s",
					map[i].start, map[i].len, map[i].fn);
			}
			st = map[i].start;
		}
	}
	printf ("\nCylinder Usage: %d cylinders (%.0f%%)\n", 
		usage, 100.* usage / Ncyl);
}
E 1
