h28077
s 00476/00000/00000
d D 1.1 84/07/25 14:28:19 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <ctype.h>
#include "ediseg.h"

/*
 * getsuf - read suffix of name, return true if name has suffix 
 */

getsuf(name, suffix)
	char *name, *suffix;
{
    register char *c; 
    char *rindex();
    c = (char *) rindex(name, *suffix);
    if (c != NULL)
	if (!strcmp(suffix, c)) return(0);
    return(-1); 
    }

/*
 * getseg - fetch ptr to segment from its segment number.
 */

struct segment *getseg(sgp, segno)
	struct segment *sgp; int segno;
{
	struct segment *s;
	for (s = sgp; s != NULL && s->segn != segno; s = s->nxtseg) ;
	if (s == NULL) printf("no such segment: %d\n", segno); 
	return(s);
	}

/*
 * rseg - read in segment file 
 * if x == 0, read segment begin time from p6,
 * else read it from p2.
 */

struct segment *rseg(name, x)
	char *name; int x;
{
	struct segment *seg = NULL, *linkseg();
	char buf[BUFSIZ];
	FILE *fopen(), *fp;

	if ((fp = fopen(name, "r")) == NULL) 
		return(NULL);

	while (fgets(buf, BUFSIZ, fp) != NULL)
		{
		if ((seg = linkseg(seg, buf, x)) == NULL) 
			return(NULL);
		}
	fclose(fp);
	return(seg);
	}

char *pn[32];

scanbuf(buf)
	char *buf;
{
	register char *c;
	register int trigger = 0, i = 1;	/* pn[0] not used */
	
	while (isspace(*buf)) buf++;
	
	for (c = buf; *c != NULL; c++) {
		if (*c == ';') break;
		if (!isspace(*c)) { 
			if (!trigger) { 
				if (*c == ',') {
					pn[i++] = c;	/* null p field */
					continue;
				}
				pn[i++] = c; 
				trigger++; 
			} 
			else {
				if (*c == ',') {
					*c = '\0';
					trigger = 0;
				}
			}
		}
		else { 
			*c = NULL; 
			trigger = 0; 
		}
	}
	return(i);
}

/*
 * linkseg - create and link new segment, description of seg in buf,
 * where buf contains "note <begin> <sound_file_name> <dur_of_seg> <segN> ;"
 * E.g.: note 0.500000 ev25 2.000000 1;
 */

struct segment *linkseg(seg, buf, x)
	struct segment *seg; char *buf; int x;
{
	extern char *malloc();
	struct segment *nseg, *lseg, *oseg = NULL;
	float sfexpr();
	/* get last element */
	for (lseg = seg; lseg != NULL; oseg = lseg, lseg = lseg->nxtseg) 
		/* empty */ ;
	/* make and fill new element */
	nseg = (struct segment *) malloc((unsigned) sizeof(struct segment));
	scanbuf(buf);	/* piece out the p fields */
	if (x == 0)
		nseg->segbeg = sfexpr(pn[6], 1.0);
	else
		nseg->segbeg = sfexpr(pn[2], 1.0);
	nseg->segend = sfexpr(pn[4], 1.0) + nseg->segbeg;
	nseg->segn = sfexpr(pn[5], 1.0);
	/* what we pick up in segend is actually duration */
/*	nseg->segend = nseg->segbeg + nseg->segend; /* convt to end time */
	nseg->lstseg = nseg->nxtseg = nseg->thread = NULL;
	if (seg == NULL) 
		seg = nseg;	/* first time */
	else 
		{ 
		oseg->nxtseg = nseg; 
		nseg->lstseg = oseg; 
		}
	return(seg);
	}

/*
 * wseg - write segment file.
 * Writes format described for linkseg.
 * Filename is added to sound file descriptor as an include file.
 */

wseg(buf, sfd, sp)
	char *buf; struct sndesc *sfd; 
	struct segment *sp;
{
	extern char *malloc();
	int pid, w, status, linked = 0;
	struct inclist *inc;
	struct segment *s;
	FILE *fopen(), *fp;
	char *file, *defile();
	if (sp == NULL) { printf("wseg: no segments\n"); return(-1); }
	file = defile(buf, sfd);
	for (inc = sfd->inclsdf; inc != NULL; inc = inc->incnext)
		{ if (!strcmp(inc->fn, file)) { linked++; break; } }
	if (!linked) 
		{
		linkinc(sfd, file);	/* add as an include file */
		printf("include file %s added to %s\n", file, sfd->sfn);
		}
	printf("writing %s\n", file);

	if ((pid = fork()) == 0)
	    {
	    register int segn = 1;
	    register float segdur, sbeg = 0;
	    setuid(getuid());	/* unset user-id mode in child */
	    if ((fp = fopen(file, "w")) == NULL) /* now open will succeed */
		    { printf("wseg: can't write file\n"); exit(-1); }
	    for (s = sp; s != NULL; s = s->nxtseg)
		{
		segdur = s->segend - s->segbeg;
		fprintf(fp, "note %f %s %f %d %f %f;\n", sbeg, sfd->sfn,
			segdur, segn++, s->segbeg, 1.0);
		sbeg += segdur;
		}
	    fclose(fp);
	    exit(0);
	    }
	/* parent - wait for process, or interrupts */
	while ((w = wait(&status)) != pid && w != -1);
	if (w == -1) return(-1);
	return(0);
	}

/*
 * segmak - make a segment from current values of begin/end registers,
 * place it on the list.
 */

segmak(sfd, fil)
	struct sndesc *sfd; int fil;
{
	struct segment *s, *o = NULL, *nseg;
	double timefac = sfd->sr * sfd->nc;
	nseg = (struct segment *) malloc(sizeof(struct segment));
	if (pf[fil].sgp == NULL) 	/* new list */
		{ 
		pf[fil].sgp = nseg; 
		nseg->segn = 1; 
		nseg->lstseg = nseg->nxtseg = NULL; 
		nseg->segbeg = pf[fil].begin/timefac;
		nseg->segend = pf[fil].end/timefac;
		return(nseg->segn);
		}
	nseg->lstseg = nseg->nxtseg = nseg->thread = NULL; 
	nseg->segbeg = pf[fil].begin/timefac;
	nseg->segend = pf[fil].end/timefac;
	for (o = s = pf[fil].sgp; 
		s != NULL && pf[fil].begin/timefac > s->segbeg; 
		o = s, s = s->nxtseg) /* empty */ ; 
	s = o;
	nseg->segn = s->segn+1;
	for (o = s->nxtseg; o != NULL; o = o->nxtseg) o->segn++;

	/* link in new segment in back of s */
	if (s->nxtseg != NULL)
		{
		s->nxtseg->lstseg = nseg;
		nseg->nxtseg = s->nxtseg;
		}
	s->nxtseg = nseg;
	nseg->lstseg = s;
	return(nseg->segn);	/* return new segment number */
	}

/*
 * segdel -delete the segment indexed by segno
 */

segdel(fil, segno)
	int fil, segno;
{
	struct segment *s, *n;

	for (s = pf[fil].sgp; s != NULL; s = s->nxtseg)
		{
		if (s->segn == segno)
			{
			if (s->nxtseg != NULL)
				s->nxtseg->lstseg = s->lstseg;
			if (s->lstseg != NULL)
				s->lstseg->nxtseg = s->nxtseg;
			break;
			}
		}
	for (n = s->nxtseg; n != NULL; n = n->nxtseg) n->segn--;
	if (s == pf[fil].sgp) pf[fil].sgp = s->nxtseg;
	free((char *) s);
	}

/*
 * defile - find seg file name.
 * If buf != NULL, use name in it, else look on include file list for first
 * file with .seg suffix.
 */

char *defile(buf, sfd)
	char *buf; struct sndesc *sfd;
{
	extern char *strcpy(), *strcat();
	char *file, *rindex(), *c;
	struct inclist *inc;
	if (*buf == NULL)
		{
		/* look for a seg file matching file name on include list */
		for (inc = sfd->inclsdf; inc != NULL; inc = inc->incnext)
			{
			if (getsuf(inc->fn, ".seg")) continue;
			file = (char *) malloc(strlen(inc->fn)+1);
			strcpy(file, inc->fn);
			break;
			}
		/* no matching seg file on include list, invent one */
		if (inc == NULL) 
			{ 
			c = rindex(sfd->sfn, '/')+1;
			if (*c == NULL) c = sfd->sfn;
			file = (char *) malloc(strlen(c)+4+1);
			strcpy(file, c);
			strcat(file, ".seg");
			}
		}
	else 
		{
		/* make name using contents of buf */
		file = (char *) malloc(strlen(buf)+1);
		strcpy(file, buf);
		}
	return(file);
	}

/*
 * listid - strips off and assigns the index to the list id variable i, and
 * jumps the buffer around the id part.  E.g., listid receives:
 * "X=1,2,3", it sets i to ('X'-'A'), and returns a pointer to "1,2,3".
 * List id's are UPPER CASE ASCII 'A' - 'Z' ONLY.
 * If no list id, or it is out of range, it sets i to -1.
 */

char *listid(buf, i)
		char *buf; int *i;
{
	char *c, *index();
	c = index(buf, EQ);
	if (c != NULL)
		{
		buf = c+1;
		*i = *(c-1) - 'A';
		if (*i > 'Z' || *i < 0) *i = -1;
		}
	else *i = -1;
	return(buf);
	}


struct segment *cplist(seg)
	struct segment *seg;
{
	struct segment *s, *r, *e, *new, *cpseg();
	int first = 1;
	for (s = seg; s; s = s->nxtseg)
		{
		new = cpseg(s);
		if (first) { e = r = new; first--; }
		else 
			{ 
			e->nxtseg = new; 
			new->lstseg = e;
			new->nxtseg = NULL;
			e = new; 
			}
		}
	return(r);
	}

/*
 * seglst - create list of segments from a list of segment numbers.
 * buf should contain comma separated list of segment numbers.
 */

struct segment *seglst(buf, fil)
	char *buf; int fil;
{
	float sfexpr();
	int n, first = 1;
	struct segment *s, *r, *e, *new, *cpseg();
	char *c, *index();
	for ( ; *buf != NULL; buf = c)
		{
		/* isolate the segment number */
		c = index(buf, ',');
		if (c != NULL) *c++ = NULL;
		n = sfexpr(buf, 1.0);
		/* find it */
		for (s = pf[fil].sgp; s != NULL; s = s->nxtseg)
			{
			if (s->segn == n) /* copy onto the list */
				{
				new = cpseg(s);
				if (first) { e = r = new; first--; }
				else 
					{ 
					e->nxtseg = new; 
					new->lstseg = e;
					new->nxtseg = NULL;
					e = new; 
					}
				break;
				}
			}
		}
	return(r);
	}

struct segment *cpseg(s)
	struct segment *s;
{
	struct segment *n;
	n = (struct segment *) malloc(sizeof(struct segment));
	n->segbeg = s->segbeg;
	n->segend = s->segend;
	n->segn = s->segn;
	n->lstseg = s->lstseg;
	n->nxtseg = s->nxtseg;
	n->thread = s->thread;
	return(n);
	}

delseg(seg)
	struct segment *seg;
{
	struct segment *s;
	for (s = seg; s != NULL; )
		if (s->nxtseg != NULL)
			{ s = s->nxtseg; free((char *) s->lstseg); }
		else
			{ free((char *) s); break; }
	}


pseg(seg)
	struct segment *seg;
{
	struct segment *s;
	if (seg == NULL)
		{
		printf("pseg: no segments\n");
		return(-1);
		}
	else
	    for (s = seg; s != NULL; s = s->nxtseg)
		ps(s);
	return(0);
	}

extern int segsav;

ps(seg)
	struct segment *seg;
{
	if (seg->segn == segsav) printf("-> ");
	else printf("   ");
	printf("%d:\tb=%6.5f\te=%6.5f\n",
		seg->segn, seg->segbeg, seg->segend);
	}

char parseg(b, segno, val, fil)
	char *b; int *segno; float *val; int fil;
{
	register char action;
	char *index();
	float sfexpr();
	if (isdigit(*b) || *b == '.') 
		{ 
		*val = sfexpr(b, 1.0); 
		return('N'); 
		}
	else
	if (*b == LAST)
		{
		struct sndesc *s = pf[fil].sfp;
		*val = s->fs / (s->nc * s->sr);
		return('N');
		}
	if (*b++ == 's')
		{
		if (*b == 'b' || *b == 'e')
			{ 
			action = *b++; 
			if (*b == LAST)
				*segno = getlast(pf[fil].sgp);
			else
				*segno = sfexpr(b, 1.0);
			*val = 0.0;
			return(action);
			}
		else
		if (isdigit(*b))
			{
			*segno = sfexpr(b, 1.0);
			return('s');
			}
		else
		if (*b == LAST)
			{
			*segno = getlast(pf[fil].sgp);
			return('s');
			}
		}
	return('\0');
	}

getlast(seg)
	struct segment *seg;
{
	struct segment *s, *o;
	for (o = s = seg; s != NULL; o = s, s = s->nxtseg) /* empty */ ;
	if (o != NULL) return(o->segn);
	return(-1);
	}
E 1
