h44576
s 00016/00019/00383
d D 1.3 84/08/10 12:10:48 disk 3 2
c now checks status return from shellcmd() 
c also moved two calls to signal()  to correct place
e
s 00007/00006/00395
d D 1.2 84/08/02 15:08:26 disk 2 1
c set ints for child to SIGDFLT so as to avoid trying to 
c close the file twice.
e
s 00401/00000/00000
d D 1.1 84/07/25 14:28:15 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
# include <sys/types.h>
# include <stdio.h>
# include <signal.h>
# include <vaxuba/dsc.h> 
# include <errno.h>
# include <sys/wait.h>
# include <carl/libsf.h>
# include "play.h"

/* #define FORKYOU		/* allows recovery from interrupts */
#define IGNORE 1	/* for crack() */
#define DONT_IGNORE 0

extern int errno;
extern int grepeat;	/* from dsdac.c */
extern char shellstr[];	/* from interact.c */

int intr;		/* interactive flag set? */
int verbose, wizard;
char defconv[] = "1,2,3,4";
extern float sfexpr();
# ifdef ASW
int asw = 1;
# endif ASW

main(argc, argv)
	int argc; char *argv[];
{
	int nfiles;
	int shutup(), icatch(), qcatch(), ichild(), qchild();
	union wait status;
	int pid, w;

	sfsetiname((char *) NULL);		/* no message on signals */

	nfiles = playparse(argc, argv);	/* read down command line */

#ifdef FORKYOU
	if ((pid = fork()) == 0) {
I 2
D 3
		if (intr) {
			signal(SIGINT, ichild); 
			signal(SIGQUIT, qchild); 
		} else {
			signal(SIGINT, SIGDFLT); 
			signal(SIGQUIT, SIGDFLT); 
		}
E 2
#endif
		/* play the sounds */
E 3
I 3
#endif FORKYOU
E 3
		if (nfiles == 0) {
			if (setup(0, "test")) 
D 3
				exit(-1); 
E 3
I 3
				exit(1); 
E 3
		} else {
			int i;

			for (i = 0; i < nfiles; i++)
				if (setup(i, pf[i].cfile)) 
D 3
					{ closeall(); exit(-1); }
E 3
I 3
					{ closeall(); exit(1); }
E 3
		}
D 2
#ifdef FORKYOU
		if (intr) {
			signal(SIGINT, ichild); 
			signal(SIGQUIT, qchild); 
		}
#endif
E 2
D 3
		if (intr)
E 3
I 3
		if (intr) {
#ifdef FORKYOU
			signal(SIGINT, ichild); 
			signal(SIGQUIT, qchild); 
#endif FORKYOU
E 3
			interact();
D 3
		else
E 3
I 3
		} else
E 3
			playall();
		closeall();
		exit(0);
#ifdef FORKYOU
	}

	/* wait for process, or interrupts */
	if (intr) {
		signal(SIGINT, icatch); 
		signal(SIGQUIT, qcatch); 
	}
	else {
		signal(SIGINT, shutup); 
		signal(SIGQUIT, shutup); 
	}
	while (((w = wait(&status)) != pid && w != -1) 
		|| (w == -1 && errno == EINTR)) 
			/* empty */; 
	if (w == -1) 
D 3
		exit(-1);
E 3
I 3
		exit(1);
E 3
	exit(0);
D 3
#endif
E 3
I 3
#endif FORKYOU
E 3
}

shutup() 
{
#ifdef debug
	printf("shutup\n");
#endif debug
	if (dsinit(DEVDSR0) < 0) 
		perror("shutup"); 
}

extern int playing;	/* from dsdac() */

icatch() 
{
#ifdef debug
	printf("icatch\n");
#endif debug
	signal(SIGINT, icatch); 
	if (dsinit(DEVDSR0) < 0) 
		perror("icatch"); 
}

extern int autoseg;

qcatch() 
{
#ifdef debug
	printf("qcatch\n");
#endif debug
	signal(SIGQUIT, qcatch);
}

int inthappened; /* set by ichild(), tells dsdac() to stop */

ichild() 
{
#ifdef debug
	printf("ichild\n");
#endif debug
	signal(SIGINT, ichild); 
	inthappened++; 
	grepeat = 0;
}


qchild() 
{
#ifdef debug
	printf("qchild\n");
#endif debug
	signal(SIGQUIT, qchild);
	if (autoseg) addseg();
}

extern int sferror;	/* declared in sopensf() */

setup(find, file)
	int find; char *file;
{
	extern char *strcpy();
	struct sndesc *sopensf(), *sfd;
	char name[128];			/* sound file name */
	double sampfac;
	struct sfstab *dirinfo(), *d;

	strcpy(name, file);

	sfd = sopensf(name, "rt", (char *) NULL);	/* open file */
	if (sfd == NULL || sferror != 0) {
		if (sferror == SFNOFILE)
			fprintf(stderr, "play: file %s not found\n", file);
		else
			fprintf(stderr,"play: opensf failed\n"); 
		return(1);
	}

	/* file has been linked on rootsfd automatically by sopensf() */
	/* now get correct device to aim the dsc driver at */
	d = dirinfo(sfd->sfn);
	if (d != NULL) {
# ifdef MAJMIN
		pf[find].dev = d->rdev;
# else MAJMIN
		pf[find].dev = d->rdevn;
# endif MAJMIN
		if (verbose) 
			printf("d->snddev=%s\n", d->snddev);
	} else {
		fprintf(stderr, "play: dirinfo failed on file %s\n", sfd->sfn);
		return(1);
	}

	/* generate correct begin and end timeing now that we know sr and nc */
	sampfac = sfd->sr * sfd->nc;
	if (pf[find].cbegin != NULL)
		pf[find].begin = sfexpr(pf[find].cbegin, sampfac);
	else
		pf[find].begin = 0;
	if (pf[find].cend != NULL)
		pf[find].end = sfexpr(pf[find].cend, sampfac);
	else
		pf[find].end = sfd->fs;		/* play whole file */

	pf[find].sfp = sfd;
	if (pf[find].srover == 0.0) 
		pf[find].srover = sfd->sr;
	if (pf[find].convover[0] == NULL)	/* no override set */
		strcpyn(pf[find].convover, defconv, sfd->nc*2-1);
	return(0);
}

/* root of linked list sopensf() creates of all open sound files */
extern struct sndesc *rootsfd;

/* step through linked list of open files */
playall()
{
	int i;
	struct sndesc *sfd;

	for ( 	sfd = rootsfd, i = 0; 
		sfd != NULL && i>=0 && i<MAXFILES; 
		sfd = sfd->nxtsdf, i++) {
			playi(i);
	}
}

playi(i)
	int i;
{
	float timefac;
	double fbeg, fend;
	CSNDFILE *sfd;

	sfd = pf[i].sfp;
	timefac = sfd->sr * sfd->nc;
	fbeg = pf[i].begin/timefac;
	fend = pf[i].end/timefac;
	if (!wizard) {
		if (cktimes(sfd, &fbeg, &fend))
			return(-1);
	}
	pf[i].begin = fbeg * timefac;
	pf[i].end = fend * timefac;
D 3
	if (shellstr[0] != '\0')
		shellcmd(i, pf[i].begin, pf[i].end);
	else
E 3
I 3
	if (shellstr[0] != '\0') {
		if (shellcmd(i, pf[i].begin, pf[i].end) != 0)
			fprintf(stderr, "shellcmd failed\n");
	} else
E 3
		if (play(sfd, pf[i].begin, pf[i].end, pf[i].silence, 
			pf[i].repeat, pf[i].prompt, pf[i].srover, 
			pf[i].fltover, pf[i].convover, pf[i].dev,
			pf[i].bno, pf[i].cnt) < 0) {
				fprintf(stderr, "play failed\n");
				return(-1);
		}
	return(0);
}

/* close all open files */
closeall()
{
	struct sndesc *sfd;

	for ( sfd = rootsfd; sfd != NULL; sfd = sfd->nxtsdf )
		sclosesf(sfd);
}

/*
 * playparse - read play command line.  Syntax is:
 * play -p {[-sN] [-rN] [file]}
 * where -s specifies N secs. silence preceeding the filename which follows
 * on the command line,
 * -r specifies N repetitions (with no silence between) of the file which
 * follows on the command line.  The -p flag causes play to wait for a prompt
 * from user before playing first file.
 * The routine fills three arrays, silences,
 * repeats, and files.  Silences and repeats are filed with durations and
 * iterations, files is filled with indicies into the argv array.
 * It returns the number of files.
 */

playparse(argc, argv)
	int argc; char **argv;
{
	char *index(), flag, *option;
	register int i, j;
	int glob=1;

	/* init end times to play whole file, no dac, nc, or filter override */
	for (i = 0; i < MAXFILES; i++) {
		pf[i].end = -1; 	/* play to end of file */
		pf[i].fltover = -1; 	/* use default filters */
		pf[i].bno = -1;		/* start at beginning block */
		pf[i].cnt = -1;		/* play all blocks */
	}

	for (i = 1, j = 0; i < argc; i++) {
		if (*argv[i] == '-'){	/* itsa flag */
			flag = *(argv[i]+1);
			option = argv[i]+2;
			switch (flag) {
				case 'b': 	/* begin */
					pf[j].cbegin = option; break;
				case 'e': 	/* end */
					pf[j].cend = option; break;
				case 'g':	/* make flags local only */
					glob=0; break;
				case 'h': 	/* wants some help */
					helpmessage(); break;
				case 'i':	/* run files interactively */
					intr++; break;
				case 'p': 	/* wants a prompt */
					pf[j].prompt = sfexpr(option, 1.0); 
					break;
				case 'q': 	/* itsa silence */
					pf[j].silence = sfexpr(option, 1.0); 
					break;
				case 'r': 	/* itsa repeat */
					pf[j].repeat = sfexpr(option, 1.0); 
					break;
				case 'v': 	/* verbose */
					verbose++; break;
# ifdef ASW
				case 'A':	/* no asw setup */
					asw = 0; break;
# endif ASW
				case 'B': 
					pf[j].bno = sfexpr(option, 1.0); break;
				case 'C': 
					pf[j].cnt = sfexpr(option, 1.0); break;
				case 'D': 	/* dac override */
					strcpy(pf[j].convover, option); break;
				case 'F': 	/* filter override */
					pf[j].fltover = sfexpr(option, 1.0); 
					break;
				case 'R': 	/* sample rate override */
					pf[j].srover = sfexpr(option, 1.0); 
					break;
				default:
					fprintf(stderr, "illegal flag: %s\n", 
						argv[i]);
					helpmessage();
				}
		} else {
			if (j >= MAXFILES) {
				fprintf(stderr,"play: too many files, max=%d\n",
					MAXFILES);
D 3
				exit(-1);
E 3
I 3
				exit(1);
E 3
			}
			pf[j++].cfile = argv[i];
			if (glob) cppsf(j, j-1); /* setup for next file */
		}
	}
	return(j);
}

/*
 * in playparse(), if the -g flag is set, cppsf() gets called to pre-set the
 * next pf[] array entry to the values of those for the previous file.
 */

cppsf(to, from)
	int to, from;
{
	pf[to].silence = pf[from].silence;
	pf[to].repeat = pf[from].repeat;
	pf[to].prompt = pf[from].prompt;
	pf[to].fltover = pf[from].fltover;
	pf[to].cbegin = pf[from].cbegin;
	pf[to].cend = pf[from].cend;
	strcpy(pf[to].convover, pf[from].convover);
}

helpmessage()
{
printf("%s%s%s%s%s%s%s%s%s%s%s%s%s", 
"usage: play [[flags] [filename]]...\n",
" -g make all flags apply only to immediately following file\n",
" -p prompts you before starting to play file\n",
" -i interactive play mode\n",
" -qN inserts N secs. silence before file\n",
" -rN repeats file N times (no gap between iterations)\n",
" -bN start file at time N\n",
" -eN end file at time N\n",
" -RN force file to be N sampling rate\n",
" -FN force use of filter N (0 =20KHz, 1 =10KHz, 2 =bypass, 3 =5KHz)\n",
" -Dw,x,y,z... set dacs to use; e.g., -D2,1 plays reverse channel stereo\n",
" -v  describe in detail what play is doing\n",
# ifdef ASW
" -A  do not invoke audio switch\n"
# else ASW
""
# endif ASW
);
exit(0);
}


/* 
 * check time in seconds against file descriptior and some
 * other reasonable constraints.
 */

cktimes(sfd, fbegin, fend)
	struct sndesc *sfd; float *fbegin, *fend;
{
	register double endtime = sfd->fs / (sfd->nc * sfd->sr);
	register int rtn = 0;
	if (*fend < *fbegin) {
		printf("error: begin must be > end\n"); 
		rtn--; 
	}
	if (*fbegin < 0) 
		*fbegin = 0.0;
	if (*fend > endtime) 
		*fend = endtime;
	return(rtn);
}
E 1
