h45747
s 00237/00000/00000
d D 1.1 84/07/25 14:28:08 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
# include <sys/types.h>
# include <stdio.h>
# include <carl/sndio.h>
# include "play.h"
# include <vaxuba/dsc.h> 
# include <vaxuba/dsreg.h>
# include <signal.h>
# include <errno.h>

/*
 * play - play sound file through converters
 * sfp = pointer to opened sound file; 
 * begin, end = time offset in seconds;
 * silence = seconds (quantized at 1 second) of silence preceeding file;
 * repeat = # times to play it, 0 times gets you 1 time;
 * prompt = waits for [RETURN] before playing file;
 * sroverride = use this sampling rate instead of what the sfp says to do;
 * fltoverride = use this filter instead of one calculated from sfp.
 */

/* declared in clck.c */
extern float    sample_rate;
extern int      wizard;
extern int      errno;
extern int      grepeat;	/* from dsdac.c */
extern int      inthappened;	/* set by ichild(), tells dsdac() to stop */

/* from playmain.c */
extern int      verbose;
extern int      autoseg;	/* from autoseg.c */
extern double   timebase,
                initime ();	/* from autoseg.c */

short   convs[] = {
	-1, -1, -1, -1, -1
};

play (sfp, begin, end, silence, repeat, prompt,
		sroverride, fltoverride, convover, dev, bno, count)
	struct sndesc  *sfp;
	long 	begin, 
		end;
	unsigned     silence;
	int	repeat,
		prompt;
	float   sroverride;
	int     fltoverride;
	char   *convover;
	int     dev;
	int     bno,
		count;
{
	extern long setfilts();
	long    stblk = 0,
	        stboff = 0,
	        nsamps = 0,
	        srate = 0,
	        filts = 0;
	register long   i,
	                j;
	int     rtn;
	float   fsrate;

	int     iplay(), qplay(), pid, w, status;

	/* set sampling rate from file or override */
	fsrate = (sroverride > 0) ? sroverride : sfp->sr;

	/* calculate DAC's version of the sampling rate */
	srate = clck(fsrate);
	if ((srate = clck(fsrate)) < 0) {
		fprintf(stderr, "sample rate: %f out of range\n", fsrate);
		return(-1);
	}

	/* sample_rate set by clck() to nearest acutal sampling rate in Hz */
	if (sample_rate != fsrate)
		printf("file sample rate of %f will be played at %f Hz\n",
				fsrate, sample_rate);

	/* convt. cyl adr to block adr */
	/* stblk = sfp->cp->base * (sfp->blksiz / BPSECTOR); */

	/* set begin time */
	stblk = stboff = begin * sfp->ssize;	/* beginning byte */
	stblk /= BPSECTOR;			/* starting sector */

	/* stboff %= BPSECTOR;			/* starting byte in buf */
	stboff %= sfp->bufsiz;			/* starting byte in buf */

	/* set end time */
	if (end < 0)		/* play whole file */
		nsamps = sfp->fs - begin;
	else {			/* play to lesser of total file or end */
		i = end - begin;
		if (i < 0) {
			printf("endtime (%d) less than begintime (%d) !!!\n",
					end, begin);
			return(-1);
		}

		if (wizard)
			nsamps = i;
		else
			nsamps = (i < sfp->fs) ? i : sfp->fs;
	}

	if (convover == NULL) {	/* do the default converters */
		for (i = 0; i < sfp->nc; i++)
			convs[i] = DACBASE + i;
	}
	else {
		for (i = j = 0; convover[i] != NULL; i++) {
			if ((convover[i] >= '1') && (convover[i] <= '4'))
				convs[j++] = DACBASE + convover[i] - '1';
		}
	}


	 /* override filter selection? */
	if (fltoverride >= 0) {	/* override set for filters */
		switch (fltoverride) {
			default: 
			case 0: 
				filts = DS20KHZ;
				break;

			case 1: 
				filts = DS10KHZ;
				break;

			case 2: 
				filts = DSBYPAS;
				break;

			case 3: 
				filts = DS5KHZ;
				break;
		}
	}
	else
		filts = setfilts(sample_rate, DA);

	if (silence > 0)
		sleep(silence);

	if (verbose) {
		printf("%s%s %s%d %s%d %s%d %s%d %s%d\n%s%f ",
				"name=", sfp->sfn,
				"begin=", begin,
				"end=", nsamps,
				"silence=", silence,
				"repeat=", repeat,
				"prompt=", prompt,
				"sr=", sample_rate);
		printf("flt= ");
		switch (filts) {
			case DS20KHZ: 
				printf("%f\n", DSCFLT0);
				break;

			case DS10KHZ: 
				printf("%f\n", DSCFLT1);
				break;

			case DSBYPAS: 
				printf("%f\n", DSCFLT2);
				break;

			case DS5KHZ: 
				printf("%f\n", DSCFLT3);
		}
	}

	if (repeat == 0)
		repeat++;	/* 0 means it was not specified */

	while (prompt) {
		char    c, getans();

		c = getans("Press [RETURN] to play, x to abort, g to go on\t");
		if ((c == 'X') || (c == 'x')) {
			fprintf(stderr, "aborting.\n");
			closeall();
			exit(1);
		}
		else {
			if ((c == 'G') || (c == 'g'))
				return(0);
			else {
				if (c == '\n')
					prompt = 0;
			}
		}
	}

	if (bno >= 0)
		stblk = bno;

	if (count >= 0)
		nsamps = count;

	timebase = initime();

	if ((pid = fork()) == 0) {
		(void) signal(SIGINT, iplay);
		(void) signal(SIGQUIT, qplay);
		rtn = dsdac(sfp, stblk, stboff, nsamps, srate, filts, repeat,
				convs, dev);
		exit(rtn);
	}

	/* wait for process, or interrupts */
	while ((w = wait(&status)) != pid) {
		if (w == -1) {
			if (errno == EINTR)
				continue;
			break;
		}
	}

	autoseg = 0;
	return(0);
}

iplay() {
/*	printf("iplay\n");*/
	(void) signal(SIGINT, iplay);
	inthappened++;
	grepeat = 0;
}

qplay() {
/*	printf("qplay\n");*/
	(void) signal(SIGQUIT, qplay);
}
E 1
