h42513
s 00072/00000/00000
d D 1.1 84/07/25 14:27:46 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <sys/types.h>
#include <carl/sndio.h>
#include <vaxuba/dsc.h>
#include <math.h>
#include <stdio.h>


/*
 * Digital Sound Corp. DAC/ADC
 * sample rate for IRCAM
 * clock freq: 7680000.0 Hz
 * clock tick: 3840000.0 Hz
 */

/*
 * Digital Sound Corp. DAC/ADC
 * sample rate calculations for CARL
 * clock freq: 6291456.0 Hz
 * clock tick: 3145728.0 Hz
 * 		  freq.   clk
 * 		  -----------
 * 		= 49152 * 128	= (48 * 1024 * 128)	= 2^14 * 3
 * 		= 32767 * 192	(32 * 1024 * 192)	= 2^15
 * 		= 24576 * 256	.
 * 		= 16384 * 384	.
 * 		= 12288 * 512	.
 * 		.
 * 		.
 * 		.
 * 	
 */

/* sample_rate has value of last sample rate calculated by clck */
float sample_rate;

clck(srate)
	double srate;
{
	int i; 
	float a, b, c;
	a = DSCMRTIC; /* tick time */

	for (i=1; i<0377777; i++ )
	    {	/* count down from highest srate */
	    /* printf("%o\t%f\n", i, a/i); */
	    if (a/i < srate) 
		    break;
	    }
	b = a/(i-1);	/* take higher rate */
	c = a/i;	/* compare to rate selected */
	if (abs(srate - c) > abs(srate - b))
	    i--;	/* take nearest one */
	sample_rate = a/i;
	if (sample_rate > DSCSRATE || sample_rate < 0)
		return(clck(DSCSRATE));
	return(i);
}

/*
 * main(argc, argv)
 * 	int argc; char **argv;
 * {
 * 	float sr = DSCSRATE;
 * 	int clk;
 * 	float asr = DSCMRTIC; /1* tick time *1/
 * 	if (argc > 1) sr = atof(argv[1]);
 * 	printf("clock rate    = %o\n", clk = clck(sr));
 * 	printf("nearest srate = %f\n",asr/(clk));
 * 	exit(0);
 * }
 */
E 1
