/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/sndio.h>
#define TRUE 1
#define FALSE 0
#define IGNORE TRUE
#define DONT_IGNORE FALSE

extern int arg_index;
extern char *arg_option;

char mode[] = "r "; int modcnt;
char *dfltvals[] = DFLTVALS;


main(argc, argv)
	char **argv;
{
	extern char *index();
	extern int usage();
	struct sndesc *sfd, *nsfd; 
	extern struct sndesc *sfoargs(), *search(), *sopensf(); 
	char ch; 
	extern char crack();
	char *ipak; 
	long start, end;

	while ((ch = crack(argc, argv, "rws", IGNORE)) != NULL)
		switch (ch) {
			case 'r': 
			case 'w': 
				if (modcnt > 1) break;
				mode[modcnt++] = ch; 
				break;
			case 's':	/* attempt to share sfd's failed */
			default:	/* no action */ ;
		}

	/* read rest of command line args if any, and open file */
	if (!index(mode, 'w')) 	/* if not writing a file (i.e. we're reading) */
		/* empty */ ; 	/* then we're done reading command line */
	else {	/* pick up additional specs. on file we'll write */
		arg_index = 0;	/* allows subsequent calls to crack() to work */
		nsfd = sfoargs(argc, argv, &ipak, &start, &end, DFLTARGS, 
			dfltvals, usage, IGNORE, FALSE);
	}
	
	if ((sfd = sopensf(argv[arg_index], mode, nsfd)) == NULL) {
		fprintf(stderr, "sopensf failed on file %s\n",
			argv[arg_index]);
		exit(1);
	}

	if (wsdf(stdout, sfd) != 0) {
		fprintf(stderr, "opensf: wsdf failed\n");
		exit(1);
	}
	exit(0);
}

usage()
{
fprintf(stderr, "%s", "usage: opensf sound_file");
}
