#! /bin/csh -f -b

# %M%	%I%	(CARL)	%G%	%U%

# foreach ARG ( ${argv} )
#	switch ( ${ARG} )
#		case -O:
#			set OVERRIDE;
#			shift;
#			breaksw;
#	endsw
# end

# make sure we are being called correctly
if ( ${#argv} < 1 ) then
	echo "mountsf: (fatal) usage: mountsf csound_filesystem"
	exit(1)
else
	set NAME = $argv[1]
endif

# if ( ${?OVERRIDE} && ` whoami ` == "disk" ) then
#	;
# else
	if ( ` tty ` != "/dev/console" ) then
		echo "umountsf: (fatal) you must run this from the console"
		exit(1)
	endif
# endif

who i is | grep -s guest
if ( ${status} == 0 ) then
	echo "umountsf: (fatal) you can't run this as guest"
	exit 1
endif

set TEMP = /tmp/sf$$
set SFSTAB = /carl/lib/sfstab

# the disk name is specified in pieces here so
# we don't have to split it up ourselves when
# we need the separate pieces.
switch ( ${NAME} )
	case /snd1:
		set SEDSTR = "/snd1:/s/xx/rw/"
		set DISK = "up1"
		set PARTITION = "e"
		breaksw

	case /snd2:
		set SEDSTR = "/snd2:/s/xx/rw/"
		set DISK = "up1"
		set PARTITION = "e"
		breaksw

	case /snd3:
		set SEDSTR = "/snd3:/s/xx/rw/"
		set DISK = "up1"
		set PARTITION = "e"
		breaksw

	case /snd4:
		set SEDSTR = "/snd4:/s/xx/rw/"
		set DISK = "up1"
		set PARTITION = "e"
		breaksw

	case /snd5:
		set SEDSTR = "/snd5:/s/xx/rw/"
		set DISK = "up1"
		set PARTITION = "e"
		breaksw

	case /snd6:
		set SEDSTR = "/snd6:/s/xx/rw/"
		set DISK = "up1"
		set PARTITION = "e"
		breaksw

	case /snd7:
		set SEDSTR = "/snd7:/s/xx/rw/"
		set DISK = "up1"
		set PARTITION = "e"
		breaksw

	case /snd8:
		set SEDSTR = "/snd8:/s/xx/rw/"
		set DISK = "up1"
		set PARTITION = "e"
		breaksw

	case /snd9:
		set SEDSTR = "/snd9:/s/xx/rw/"
		set DISK = "up1"
		set PARTITION = "e"
		breaksw

	case /snd10:
		set SEDSTR = "/snd10:/s/xx/rw/"
		set DISK = "up1"
		set PARTITION = "e"
		breaksw

	default:
		echo "mountsf: (fatal) don't know about $NAME"
		exit(1)
endsw

# check the filesystem name first
# one of fsck's messages is
#	... Last Mounted on name
/etc/fsck -n /dev/r${DISK}${PARTITION} | grep -s ${NAME}
if ( ${status} != 0 ) then
	echo "mountsf: (fatal) this disk doesn't appear to be ${NAME}"
	exit(1)
endif

# check the filesystem first
/etc/fsck -n /dev/r${DISK}${PARTITION}
if ( ${status} != 0 ) then
	echo "mountsf: (fatal) file system has inconsistencies; bye\!"
	exit(1)
endif

# now mount it
/etc/mount /dev/${DISK}${PARTITION} ${NAME}
if ( ${status} != 0 ) then
	echo "mountsf: (fatal) mount failed"
	exit(1)
endif

# fix SFSTAB to show that it is online
/bin/sed ${SEDSTR} ${SFSTAB} >! ${TEMP}
if ( ${status} != 0 ) then
	echo "mountsf: (fatal) sed failed"
	exit(1)
endif
cp ${TEMP} ${SFSTAB}
if ( ${status} != 0 ) then
	echo "mountsf: (fatal) mv of sfstab failed"
	exit(1)
endif
/etc/chown disk ${SFSTAB}

# fix FSTAB; don't bomb out if this disk isn't in it though
grep -s ${DISK}${PARTITION} /etc/fstab
if ( $status != 0 ) then
	echo "mountsf: (warning) ${DISK}${PARTITION} not in fstab"
	echo "mountsf: please notify a system maintenance person"
else
	grep -s ${NAME} /etc/fstab
	if ( $status != 0 ) then
		echo "mountsf: (warning) ${NAME} not in fstab"
		echo "mountsf: please notify a system maintenance person"
	else
		# turn off all partitions
		/bin/sed -e "/${DISK}/s/:rw:/:xx:/" /etc/fstab >! ${TEMP}

		# turn on snd partition
		onintr -
		/bin/sed -e "/`basename ${NAME}`/s/:xx:/:rw:/" ${TEMP} >! /etc/fstab
		onintr
endif

# check the csound free list, etc.
sfck -B ${NAME}
if ( $status != 0 ) then
	echo "mountsf: (warning) ${NAME} has free list errors."
	echo "mountsf: please notify a system maintenance person before proceeding"
endif

/carl/bin/unlocksf ${NAME}

set WHOAMI = ` who i is `
echo "$WHOAMI[1]	`date`" >! ${NAME}/mounted_by

rm -f ${TEMP}
