/* prsdf.c	1.2	(CARL)	9/13/84	09:34:02 */
#include <stdio.h>
#include <carl/libsf.h>

/* 
 * prettyprint an in-core sound file descriptor on i/o channel fp.  
 */

prsdf(fp, sdp, prblks)	
	FILE *fp; 
	struct sndesc *sdp;
	int prblks;
{
	struct dskblk *cp;
	struct inclist *inc;
	struct comlist *com;
	double dur;

	/* is there any reason to go on? */
	if (sdp == NULL) 
		return(-1);

	fprintf(fp,"%-32s%-14s%-11s%-10s%-10s\n", 
		"name:", "owner:", "cylinders:", "contig.:", "protection:");
	fprintf(fp,"%-32s%-14s%-11D%-10c%-10o\n", 
		sdp->sfn, sdp->sfown, sdp->ncyls, sdp->rtflag, sdp->fprot);

	dur = sdp->nc * sdp->sr;
	if (dur != 0.0)
		dur = sdp->fs / dur;
	fprintf(fp, "%-16s%-16s%-14s%-11s%-10s%-10s\n",
		"rate:","class:","packing:","channels:", "length:","duration:");
	fprintf(fp, "%-16.3f%-16c%-14c%-11d%-10D%-10.3f\n",
		sdp->sr, sdp->fhold=='\0'?SCRAT:sdp->fhold, 
		sdp->pm, sdp->nc, sdp->fs, dur);

	/* write out comment(s) */
	for (com = sdp->comsdf; com != NULL; com = com->comnext) {
		if (com != NULL) 
			fprintf(fp,"%s\n",com->cmt);
	}

	/* what time is it? */
	fprintf(fp, "%-26s%-26s%-26s\n", "created:", "referenced:", "altered:");
	prtime(fp, sdp->cdate, ' ');
	prtime(fp, sdp->rdate, ' ');
	prtime(fp, sdp->adate, '\n');
	if (sdp->dumpd == 0) 
		fprintf(fp, "not dumped.\n");
	else {
		fprintf(fp, "%-26s", "dumped:");
		prtime(fp, sdp->dumpd, ' ');
		fprintf(fp, "on dump tape %ld\n", QTAPEID(sdp->tpkey)); 
	}


	/* write include file strings */
	for (inc = sdp->inclsdf; inc != NULL; inc = inc->incnext) {
		if (inc != NULL) 
			fprintf(fp,"#include: \"%s\"\n",inc->fn);
	}

	/* write cylinder blocks */
	if (prblks) {
		fprintf(fp, "flag:\tbase:\tlen:\tseqence:\n");
		for (cp = sdp->cp; cp != NULL; cp = cp->next) { 
			fprintf(fp, "%c\t%d\t%d\t%d\n",
				cp->flag, cp->base, cp->len, cp->seq);
		}
	}

	return(0);
}
