/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <carl/libsf.h>

struct stat stbuf;	/* buffer for stat() */

extern char *arg_option;
extern int arg_index;
extern char crack();

/* diread() uses these */
#define DI_ALL 1
#define DI_EXACT 2
#define DI_PARTIAL 4
#define DI_ONEDIR 8

/* diread builds string array on these */
extern char **difiles;
extern int difilcnt;

/* defines for selecting lsf format */
# define bit(n)		((1) << (n))
#define SHORT	bit(0)
#define LONG	bit(1)
#define SFD	bit(2)
#define ALLFIL	bit(3)
#define REVERSE	bit(4)
#define DATE	bit(5)
#define CSIZE	bit(6)
#define PRBLK	bit(7)
#define NOPATH	bit(8)

/* defines for numeric format: dfmt */
#define ATIME 'a'	/* time last altered */
#define RTIME 'r'	/* time last referenced */
#define CTIME 'c'	/* time created */
#define DTIME 'd'

int obj, otty;
int fmt = SHORT, mode = (DI_EXACT | DI_ONEDIR);
char dfmt = CTIME;
int dmp, level;
long ddate, getddate();
struct datfil 
	{
	char *fname;
	long date;
	} **fildates;

main(argc, argv)
	char **argv;
{
	extern	char *rindex();
	char ch, *key = NULL, *getsfn();
	int dcmp(), scmp();
	int n, q;

	otty = isatty(1);

	while ((ch = crack(argc, argv, "0123456789shClfFp|Rrat|", 0)) != NULL)
		{
		char *index();
		switch (ch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9': 
				dmp++; 
				level = ch - '0'; 
				fmt &= ~CSIZE;
				fmt |= DATE;
				dfmt = DTIME;
				break;

			case 's':
				fmt |= NOPATH;
				break;

			case 'l':
				fmt &= ~SFD;
				fmt |= LONG;
				fmt |= NOPATH;
				break;

			case 'f': fmt &= ~LONG; fmt |= SFD; break;
			case 'F': fmt &= ~LONG; fmt |= SFD | PRBLK; break;
			case 'a': fmt |= ALLFIL; break;
			case 'C': fmt &= ~DATE; fmt |= CSIZE; break;
			case 'r': fmt |= REVERSE; break;
			case 't': 
				fmt &= ~CSIZE;
				fmt |= DATE; 
				if (*arg_option == CTIME ||
						*arg_option == RTIME ||
						*arg_option == DTIME ||
						*arg_option == ATIME)
					dfmt = *arg_option;
				break;
			case 'p': 
				key = arg_option;
				mode &= ~DI_EXACT; 
				mode |= DI_PARTIAL; 
				break;
			case 'R': mode &= ~DI_ONEDIR; break;
			case 'h': lsfusage(0);
			default:  lsfusage(1);
			}
		}

	if (argc - arg_index == 0) 	/* no args, maybe only flags */
		{
		struct defnamtab *getdefnam();
		argv[1] = (char *) malloc(128);
		strcat(argv[1], getdefnam()->path); 
		if (argc == 1) argc++;
		}

	while (--argc) {
		if ((obj=sftype(*++argv)) == SDEV  || obj == SDIR) {
			if (!(mode & DI_PARTIAL)) {
				mode |= DI_ALL;
				mode &= ~DI_EXACT;
			}
			if (obj == SDEV) 
				mode &= ~DI_ONEDIR; 
			if (strcmp(*argv, ".") == 0) {
				char *c;
				*argv = getsfn(NULL, 1);
				if ((c = rindex(*argv, '/')) != NULL)
					*c = '\0';
			} else if (strncmp(*argv, "..", 2) == 0) {
				char *c;
				*argv = getsfn(*argv, 0);
				if ((c = rindex(*argv, '/')) != NULL) {
					if (*(c+1) == '\0')
						*c = '\0';
				}
			} else if (obj == SDIR) {
				*argv = getsfn(*argv, 0);
			}
			if (diread(*argv, key, mode) < 0) 
				exit(1);
		} else {
			char *c, *d, *allocat();
			c = getsfn(*argv, 0);
			d = allocat(c, SDFEXT); 
			if (access(d, 0) == 0) 
				difilcnt = strsav(&difiles, d);
			free(c);
			free(d);
		}
	}
	if (difilcnt == 0) 
		exit(0);
	if (dmp)
		/* dump date is gotten from device of first file named */
		if ((ddate = getddate(level, difiles[0])) < 0)
			exit(1);
	if (fmt & DATE) {
		char *stripsuf(), name[128];
		struct sndesc *x, *accesf();
		struct datfil *y;
		fildates = (struct datfil **) 
			calloc(sizeof(struct datfil *) * difilcnt, 1);
		for (n = q = 0; n < difilcnt; n++) {
			strcpy(name, difiles[n]);
			if (stripsuf(name, SDFEXT) == NULL)
				continue;
			if ((x = accesf(name)) == NULL) {
				fprintf(stderr, "lsf: accesf error: %s\n",
					difiles[n]);
				continue;
				}
			if (dmp) {
				if (x->dumpd != 0 && ddate >= x->dumpd )
					continue;
				}
			y = (struct datfil *) malloc(sizeof(struct datfil));
			y->fname = difiles[n];
			if (fmt & CSIZE)
				y->date = x->ncyls;
			else {
				switch (dfmt) {
					case ATIME: y->date = x->adate;
						break;
					case RTIME: y->date = x->rdate;
						break;
					case CTIME: y->date = x->cdate;
						break;
					case DTIME: y->date = x->dumpd;
						break;
					}
			}
			fildates[q++] = y;
			freesfd(x);
		}
		/* sort by date */
		difilcnt = q;
		qsort(fildates, difilcnt, sizeof(struct datfil *), dcmp);
		/* overwrite original list with new order */
		for (n = 0; n < difilcnt; n++)
			difiles[n] = fildates[n]->fname;
		}
	else
		qsort(difiles, difilcnt, sizeof(char *), scmp);

	printit(difiles, difilcnt, fmt);
	exit(0);
}

lsfusage(x) 
{
fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s%s%s%s%s",
"usage: lsf [flags] { [file] | [device] | [directory] } ... \n",
" flags:\n",
" -R\trecursively search directories\n",
" -l\tprint long format\n",
" -f\tprint sound file descriptor\n",
" -F\tprint sound file descriptor with disk block list\n",
" -pX\tprint only files with substring X in filename\n",
" -tX\tsort files according to date\n",
"\t\tX = 'c'\tsort by creation date (default)\n",
"\t\tX = 'a'\tsort by date last altered\n",
"\t\tX = 'r'\tsort by date last referenced\n",
" -C\tsort files according to size in cylinders\n",
" -r\treverse sort\n",
" -a\tprint all files\n"
);
exit(x);
}

#define TABSTOP 8
#define LINEWIDTH 80
int fieldsiz;
long int csize;


printit(namelist, cnt, frmt)
	char **namelist; int cnt, frmt;
{
	extern	char *realloc();
	extern	char *rindex();
	extern	char *stripsuf();
	int n, l, widest = 0;
	if (cnt <= 0) 
		{ putchar('\n'); return; }
	for (n = 0; n < cnt; n++) {	/* find biggest field */
		if (namelist[n] == NULL)
			continue;

# ifdef nopath
		strcpy(fullname, namelist[n]);
		if (frmt & NOPATH) {
			if ((cp = rindex(namelist[n], '/')) != NULL) {
				strcpy(tbuf, cp+1);
				namelist[n] = realloc(namelist[n],
					strlen(tbuf)+1);
				strcpy(namelist[n], tbuf);
			}
		}
# endif nopath

		if (stripsuf(namelist[n], SDFEXT) == NULL) {
# ifdef nopath
			if (isdir(fullname) != SDIR) {
# else nopath
			if (isdir(namelist[n]) != SDIR) {
# endif nopath
				if (!(frmt & ALLFIL)) {
					free(namelist[n]);
					namelist[n] = NULL;
					continue;
				} 
			} else {
				namelist[n] = realloc(namelist[n],
					strlen(namelist[n])+2);
				strcat(namelist[n], "/");
			}
		}
		l = strlen(namelist[n]);
		widest = widest < l ? l : widest;
	}
	widest++;
	fieldsiz = LINEWIDTH / widest;		/* how many fields per line? */
	if (fieldsiz <= 0)			/* VERY long name */
		fieldsiz = 1;
	fieldsiz = LINEWIDTH / fieldsiz;	/* how big are the fields? */
	l = fieldsiz;				/* copy it */
	fieldsiz = fieldsiz / TABSTOP * TABSTOP;/* adjust to tab widths */ 
	fieldsiz += l % TABSTOP ? TABSTOP : 0;
	for (n = 0; n < cnt; n++)
		pel(namelist[n], frmt);
	if (otty && (frmt & SHORT))
		putchar('\n');
	if (frmt & LONG)
		printf("total cylinders: %d\n", csize);
}

pel(name, fmt)
	char *name; int fmt;
{
	struct sndesc *sfd, *accesf();

	if (name == NULL) 
		return;

	if (fmt & LONG) {
		struct dskblk *x;

		if ((sfd = accesf(name)) == NULL) {
			if (isdir(name)) {
				pfirst(dfmt);
				printf("%-20sdirectory\n", name);
				return;
			}
		}
		ple(sfd, dfmt, obj==SDEV ? 0 : 1);
		for (x = sfd->cp; x; x = x->next)
			csize += x->len;
	} else if (fmt & SFD) {
		if ((sfd = accesf(name)) == NULL)
			return;
		prsdf(stdout, sfd, fmt & PRBLK);
		freesfd(sfd);
	} else if (!otty)
		printf("%s\n", name);
	else {
		pcol(name); 
	}
}

pfirst(dfrmt)
	int dfrmt;
{
	static int first;
	char *timeline; 
	extern char *index(), *ctime();
	char *at = "altered",
		*rt = "referenced", *ct = "created", *dt = "dumped";

	if (first == 0)
		first++;
	else
		return;

	switch (dfrmt) {
		case ATIME: 
			timeline = at;
			break;
		case RTIME: 
			timeline = rt;
			break;
		case CTIME: 
			timeline = ct;
			break;
		case DTIME: 
			timeline = dt;
			break;
		}
	printf("%-20s%4s%5s%3s%8s%5s %-3s %-26s\n", "name", "stat", 
		"pro", "sc", "own", "siz", "rt", timeline);
}

scmp(s1, s2)
	char **s1, **s2;
{
	register int n;
	n = strcmp(*s1, *s2);
	if (fmt & REVERSE) n = -n;
	return(n);
	}

dcmp(n1, n2)
	struct datfil **n1, **n2;
{
	register int n;
	if (*n1 == NULL || *n2 == NULL) 
		return(0);
	n = (*n1)->date - (*n2)->date;
	if (fmt & REVERSE) n = -n;
	return(n);
	}

pcol(name)
	char *name;
{
	static int pos;
	int len, rem, x, s;

	len = strlen(name);
	if (pos + fieldsiz > LINEWIDTH)
		{
		putchar('\n');
		pos = 0;
		}
	printf("%s", name);
	pos += fieldsiz;		/* incr. pos to next field stop */
	if (pos + fieldsiz > LINEWIDTH) /* will next field overflow line? */
		return;			/* don't pad to 'next' field stop */
	x = len / TABSTOP * TABSTOP;	/* figure out where next tab stop is */
	x += x % len ? TABSTOP : 0;	/* round up if necessary */
	s = x - len;			/* put out s spaces */
	rem = fieldsiz - x;		/* put out t tabs */
	while (s--)			/* get to next field stop */
		putchar(' ');
	while (rem)
		{
		putchar('\t');
		rem -= 8;
		}
	}


ple(sfd, dfrmt, stripd)
	struct sndesc *sfd; char dfrmt; int stripd;
{
	extern	char *index(), *rindex(), *ctime();
	char *c, *timestr, *at = "altered", *nd = "not dumped";

	switch (dfrmt) {
		case ATIME: 
			timestr = ctime(&sfd->adate); 
			break;
		case RTIME: 
			timestr = ctime(&sfd->rdate); 
			break;
		case CTIME: 
			timestr = ctime(&sfd->cdate); 
			break;
		case DTIME: 
			if (sfd->dumpd == 0)
				timestr = nd;
			else
				timestr = ctime(&sfd->dumpd); 
			break;
	}
	c = index(timestr, '\n');
	if (c != NULL) *c = NULL;

	if (stripd) 			/* strip device */
		c = index(sfd->sfn+1, '/');
	else
		c = sfd->sfn;

	pfirst(dfrmt);
	printf("%-20s%4d%5o%3c%8s%5d%3c %-26s\n",
		c, sfd->rw, sfd->fprot, sfd->fhold, sfd->sfown,
		sfd->ncyls, sfd->rtflag, timestr);
}

struct incinfo
    {
    int dumplevel;
    long dumpdate;
    int tapeid;
    int tapeidmax;
    };

long getddate(lvl, name)
	int lvl; char *name;
{
	struct sfstab *dirinfo();
	struct incinfo *x, *getinc();
	int i;

	if (lvl == 0) {
		fprintf(stderr, "lsf: no files dumped before level 0!\n");
		return(-1);
	}
	for (i = lvl-1; i >= 0; i--) {
		x = getinc(i, dirinfo(name)->sdfdir);
		if (x->dumplevel == i)
			return(x->dumpdate);
		}
	return(0);
}
