h30682
s 00069/00000/00000
d D 1.1 84/07/25 14:21:05 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>

/* 
 * verbosly print an in-core sound file descriptor on i/o channel fp.  
 */

vsdf(fp, sdp)	
	FILE *fp; struct sndesc *sdp;
{
    struct dskblk *cp;
    struct inclist *inc;
    float dur;
    char *type = "type:";

    /* is there any reason to go on? */
    if (sdp == NULL) return(-1);
    dur = sdp->fs/(sdp->nc*sdp->sr);

    fprintf(fp, "%-12s%s\n", "name:", sdp->sfn);
    fprintf(fp, "%-12s%s\n", "owner:", sdp->sfown);
    switch (sdp->fhold) {
	case '\0': break;
	case SCRAT: fprintf(fp, "%-12s%s\n", type, "scratch"); break;
	case SHOLD: fprintf(fp, "%-12s%s\n", type, "hold"); break;
	case SKEEP: fprintf(fp, "%-12s%s\n", type, "keep"); break;
    }
    fprintf(fp, "%-12s%s\n", "contiguous:", sdp->rtflag==RT?"yes":"no");
    fprintf(fp, "%-12s%o\n", "protection:", sdp->fprot);
    fprintf(fp, "%-11s%6.3f\n", "duration:", dur);
    fprintf(fp, "%-12s%D\n", "length:", sdp->fs);
    fprintf(fp, "%-12s%6.3f\n", "rate:", sdp->sr);
    fprintf(fp, "%-12s%d\n", "channels:", sdp->nc);
    fprintf(fp, "%-12s%D\n", "cylinders:", sdp->ncyls);
    fprintf(fp, "%-12s%c\n", "packing:", sdp->pm);

    /* write out comment */
    if (sdp->comment != NULL) fprintf(fp,"%s\n",sdp->comment);

    /* what time is it? */
    fprintf(fp, "%-12s", "created:");
    prtime(fp, sdp->cdate, '\n');
    fprintf(fp, "%-12s", "referenced:");
    prtime(fp, sdp->rdate, '\n');
    fprintf(fp,"%-12s",  "altered:");
    prtime(fp, sdp->adate, '\n');

    fprintf(fp, "%-12s", "dump date:");
    if (sdp->dumpd == 0) fprintf(fp, "not dumped.\n");
    else 
	{
	prtime(fp, sdp->dumpd, ' ');
	fprintf(fp, "on dump tape %ld\n", QTAPEID(sdp->tpkey)); 
	}

    /* write include file strings */
    for (inc = sdp->inclsdf; inc != NULL; inc = inc->incnext)
	if (inc != NULL) fprintf(fp,"#include: \"%s\"\n",inc->fn);

    /* write cylinder blocks */
    for (cp = sdp->cp; cp != NULL; cp = cp->next) 
	fprintf(fp, "%-12s%-6s%c %-6s%d %-6s%d\n", "block:", 
		"flag:", cp->flag, "base:", cp->base, "len:", cp->len);

    return(0);
    }


E 1
