h22187
s 00053/00000/00000
d D 1.1 84/07/25 14:20:55 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>

extern int sferror;

/*
 * lookup looks for a named sdf file.  returns the sound file descriptor
 * if successful, else NULL.
 * It subjects name to filename expansion via getsfn() and tacks on the
 * SDFEXT extension.
 */

struct sndesc *lookup(name)
	char *name;
{
    struct sndesc *sfd, *rsdf();
    char *o, *p;
    char *getsfn();
    if (name == NULL) return(NULL);
    if (ismlocked(name) < 0) {
	fprintf(stderr, "lookup: %s is masterlocked\n", getsfile(NULL));
	return(NULL);
    }
    o = getsfn(name, 0);
    p = (char *) malloc(strlen(o)+strlen(SDFEXT)+1);
    strcpy(p, o); 
    strcat(p, SDFEXT);
    sfd = rsdf(NULL, p);
    free(o); 
    free(p);
    if (sferror & SFDER)
	{
	fprintf(stderr, "lookup: error reading %s\n", name);
	return(NULL);
	}
    return(sfd);
    }

/*
 * main(argc, argv)
 * 	int argc; char **argv;
 * {
 * 
 * 	while (--argc)
 * 		{
 * 		struct sfentry *sfe, *lookup();
 * 		sfe = lookup(*++argv);
 * 		if (sfe != NULL)
 * 			printf("%s\n", sfe->entry);
 * 		}
 * 	}
 */
E 1
