/* xpandsf.c	1.1	(CARL)	7/25/84	13:45:20 */
#include <stdio.h>
#include <carl/libsf.h>
extern char *malloc(), *calloc(), *realloc();

/* 
 * xpandsf - expand allocation of a file
 */

extern int      interlock;	/* from allocsf.c */
extern int      quitit ();

xpandsf (sfd, howmany)
	struct sndesc  *sfd;
	long    howmany;
{
	extern long zapfree();
	extern char *strcpy();
	struct dskblk  *head,
	               *ptr,
	               *xclaim (), *claim (), *q, *oq,
	               *sfgetfl (), *makenode ();
	long    seq;
#ifdef INFINITE
	long    loop = 0,
	        toomany = 32768;
#endif INFINITE

	ignall ();


	interlock = 1;		/* lock allocation arena until wlist()
				   below */
	if ((head = sfgetfl (sfd -> sfn, 0)) == NULL)
		return (-1);
#ifdef DEBUG
	fprintf (stderr, "xpandsf: %s locked\n", sfd -> sfn);
#endif DEBUG
	if (zapfree (head) < 0L) {
		fprintf (stderr,
				"xpandsf: error compacting free list\n");
		return (-1);
	}

 /* get sequence number */
	if (sfd -> cp == NULL)
		seq = 0;	/* it will be incremented below */
	else {			/* get last list member in oq also */
		for (q = sfd -> cp; q != NULL; oq = q, q = q -> next) {
#ifdef INFINITE
			if (loop++ > toomany) {
				fprintf ("xpandsf: aborting infinite loop\n");
				return (-1);
			}
#endif INFINITE
		}
		seq = oq -> seq;/* pick up sequence # */
	}

 /* look for contiguous block expansion */
	ptr = xclaim (head, howmany, oq);

 /* can't expand size of current block, so look for new block */
	if (ptr == NULL) {
		if ((ptr = claim (head, howmany)) == NULL)
			return (-1);
	/* fix up claimed node for free list */
		ptr -> dfn = (char *) malloc ((unsigned) strlen (sfd -> sfn)+1);
		if (ptr -> dfn == NULL)
			malerr("xpandsf", 1);
		(void) strcpy (ptr -> dfn, sfd -> sfn);
		ptr -> dsksfd = sfd;
		ptr -> cd = sfd -> cdate;
		ptr -> seq = ++seq;
	/* make copy of node to pass back, will become the link in sfd */
		ptr = makenode (NULL, NULL, ptr -> base, ptr -> len, 
			ptr -> flag, NULL, NULL, 0L, seq);
		if (sfd -> cp == NULL)/* first time */
			sfd -> cp = ptr;
		else {		/* put it at the end */
			oq -> next = ptr;/* this is end of list */
			ptr -> last = oq;/* back link */
			ptr -> next = NULL;
				/* silver stake in its heart */
		}

	}

	if (wlist (head, sfd -> sfn, 1) != 0)
		return (-1);

	sfd -> ncyls += howmany;
	catchall (quitit);

	return (0);
}

struct dskblk  *
                xclaim (head, cyls, xblk)
struct dskblk  *head;
long    cyls;
struct dskblk  *xblk;
{
	struct dskblk  *dp;
#ifdef INFINITE
	long    n = 0,
	        toomany = 32768;
#endif INFINITE

	if (cyls <= 0 || head == NULL || xblk == NULL)
		return (NULL);

 /* seek to block to expand */
	for (dp = head; dp -> flag != EOLIST; dp = dp -> next) {
		if (dp -> base == xblk -> base)
			break;
#ifdef INFINITE
		if (n++ >= toomany) {
			fprintf (stderr, "xclaim: aborting infinite loop\n");
			return (NULL);/* infinite loop? */
		}
#endif INFINITE
	}

 /* not found? */
	if (dp -> flag == EOLIST)
		return (NULL);
 /* can we expand it? */
	if (
	    dp->base + dp->len == dp->next->base 
	    && dp->next->flag == UNUSED 
	    && dp->next->len >= cyls
	) {
		if (dp -> next -> len == cyls) {
			struct dskblk  *p;

			p = dp -> next;
			p -> last -> next = p -> next;
			p -> next -> last = p -> last;
			if (p -> dfn != NULL)
				free (p -> dfn);
			free ((char *) p);
		}
		else {
			dp -> next -> base += cyls;
			dp -> next -> len -= cyls;
		}
		dp -> len += cyls;
		xblk -> len += cyls;
		return (dp);
	}
	return (NULL);
}
