/* sfstab.c	1.1	(CARL)	7/25/84	13:44:30 */
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <carl/libsf.h>
extern char *malloc(), *calloc(), *realloc();
 
/*
 * sfstab - read in the sound file system configuration table for
 * a particular sound system directory.  Entries in that table are of
 * the following form:
 * sdf_directory:raw_device:mode:size_in_cylinders:device_number:track_size\n
 * Valid modes are: xx = ignore, rx = readonly, rw = readwrite.
 * The rdevn field indexes a table of open raw devices in sopensf().
 * (If you have DSC converters, rdevn is also the index into the table
 * of raw storage devices that the CARL DSC driver knows about).
 * Each raw device should have a unique rdevn number, monotonically
 * increasing from 0.  
 * NSFSYS devices are allowed, set in libsf.h
 * For instance:
 * 
 * /snd:/dev/rxy0c:rw:409:0
 *
 * NSFSYS must be >= the number of current entries in sfstab.
 */

struct sfstab *Rsfstab=NULL;

struct sfstab *getsfstab()
{
	extern char *strcpy();
	extern long atol();
	extern char *index();
	struct sfstab *sfs, *old = NULL;
	char colon=':';
	FILE *fp;
	char buf[128];

	if (Rsfstab != NULL) 
		return(Rsfstab);
	if ((fp = fopen(SFSTAB, "r")) == NULL) 
		return(NULL);
	while (fgets(buf, 128, fp) != NULL) {
		register char *c, *d, *e; 
		char *index();
		register int i;

		if ((sfs = (struct sfstab *)malloc((unsigned) 
			sizeof(struct sfstab))) == NULL)
				malerr("getsfstab", 1);
		if (Rsfstab == NULL) 
			Rsfstab = sfs;
		for (d=buf, i=0; i < SFSTABN; i++) {
			c = index(d, colon);
			if (c != NULL) 
				*c++ = NULL;
			else {
				fprintf(stderr, "getsfstab: missing colon\n");
				return(NULL);
			}
			if ((e = (char *) malloc((unsigned) strlen(d)+1))==NULL)
				malerr("getsfstab", 1);
			(void) strcpy(e, d);
			switch (i) {
				case 0: sfs->sdfdir = e; break;
				case 1: sfs->snddev = e;
# ifdef MAJMIN
					sfs->rdev = getdev(e);
# endif MAJMIN
				break;
				case 2: sfs->devmode = e; break;
				case 3: sfs->devlen = atol(e); free(e); break;
				case 4: sfs->rdevn = atol(e); free(e); break;
				case 5:
					sfs->bsize = atol(e);
					free(e);
					break;
				case 6:
					sfs->lkdev = e;
					break;
				case 7:
					sfs->bpblock = atol(e);
					free(e);
					break;
				default:
					break;
			}
			d = c;
		}
		if (old != NULL) { 
			sfs->lstsfstab = old; 
			old->nxtsfstab = sfs; 
		}
		sfs->nxtsfstab = NULL;
		old = sfs;
	}
	if (fclose(fp) < 0)
		perror("fclose");
	return(Rsfstab);
}


/* 
 * dirinfo - return sfstab info for a particular sound device, returns NULL if
 * no such device.
 */

struct sfstab *dirinfo(dir)
	char *dir;
{
	register struct sfstab *s; 
	struct sfstab *getsfstab();
	char *index(), *c, *d;
	register int i;

	if ((i = strlen(dir)) == 0)
		return(NULL);
	if ((d = (char *) malloc((unsigned) i+1)) == NULL)
		malerr("dirinfo", 1);
	(void) strcpy(d, dir);
/*###117 [lint] index value used inconsistently accesf.c(58) :: sfstab.c(117)%%%*/
	c = index(d+1, '/');
	if (c != NULL)
		*c = NULL;

/*###121 [lint] getsfs value used inconsistently sfsdevs.c(11) :: sfstab.c(121)%%%*/
/*###121 [lint] getsfs value declared inconsistently sfsdevs.c(11) :: sfstab.c(121)%%%*/
	for ( s = getsfstab(); s != NULL; s = s->nxtsfstab ) {
		if (!strcmp(d, s->sdfdir))
			break;
	}
	free(d);
	return(s);
}

# ifdef MAJMIN
/*
 * get major+minor of a node in /dev
 *
 */
getdev(name)
char *name;
{
	struct stat stb;

	if (stat(name, &stb) == -1)
		return(-1);

	return(stb.st_rdev);
}
# endif MAJMIN
