/* sfquitit.c	1.1	(CARL)	7/25/84	13:44:22 */
#include<stdio.h>
#include<carl/sndio.h>
#include <signal.h>

/*
 * sfquitit - user level routine, set up for catching interrupts by
 * opensf() and closesf() from within a user job.  N.B., user jobs
 * must either leave interrupts alone, or themselves call sfallclose()
 * before exiting.
 */

extern struct sndesc   *rootsfd;
extern char    *sigs[];

sfquitit (ind)
int     ind;
{
	ignall ();		/* ignore all interrupts */
	if ((ind != SIGINT && ind != SIGQUIT)) {
		fprintf (stderr, "\ninterrupt: %s\n", sigs[ind]);
	}

	if (sfallclose () != 0)
		fprintf (stderr, "sfquitit: error closing files\n");

	exit (1);
}
