/* sfoargs.c	1.2	(CARL)	12/17/84	12:30:52 */
#include <stdio.h>
#include <carl/libsf.h>
#define TRUE 1
#define FALSE 0
#define FLAGS "c|i|o|R|I|C|T|p|t|b|e|d|r|SHKhF"

/*
 * Used by sndout and friends.  Flags are interpreted as:
 * flags: (val:default) 
 * c =chans(1,2,3,4...N:1), 
 * R =sample Rate(49152.0), 
 * i =input packing(s,f:f), sets ipak 
 * o =output packing(s,f:s), maps to setsfd flag P
 * T =time, converts time in seconds to correct size block (see documentation),
 * C =cyls(1), 
 * t =realtime flag (r,n:r),
 * r =remark(NULL),
 * I =include(NULL), 
 * p =protection(0644), 
 * F =update ('F'lush) sfd after each call to sndo().
 * S =scratch file
 * H =hole file
 * K =keep file
 */

extern char    *arg_option;
extern int      arg_index;
extern char    *getsfn ();	/* from libsf */
extern char    *sprintf ();
char    defnam[] = SDFSFN;
char    sfoflags[32];		/* string of flag characters parsed */

struct sndesc  
*sfoargs (argc, argv, ipak, stsamp, endsamp, deflags, 
		defargs, usage, ign, openit)
	int     argc;
	char   *argv[];
	char   *ipak;
	long   *stsamp,
	       *endsamp;
	char   *deflags;
	char  **defargs;
	int     (*usage) ();
	int     ign,
		openit;
{
	extern char *index();
	struct sfstab  *dirinfo (), *sfs;
	char    ch,
	        getopt (), *cp = sfoflags;
	char   *timsav,
	       *begsav,
	       *endsav = "-1",
	        expstr[32],
	       *name;
	float   flt,
	        sfexpr ();
	struct sndesc  *sfd = NULL,
	               *dfltsfd (), *setsfd (), *sopensf ();
	double  begin = 0.0,
	        end = -1.0;
	int     timeset = 0,
	        rt = FALSE;
	char   *omode = "w F";	/* default i/o mode */
 /* reserved: omode[0]='w', omode[1]='r', omode[2]='F' */
	register float  samplesecond;

	arg_index = 0;	/* reset crack in case we're not the first ones */
	while ((ch = crack (argc, argv, FLAGS, ign)) != NULL) {
		*cp++ = ch;
		*cp = NULL;	/* add flag to sfoflags */
		switch (ch) {
			case SCRAT: 
			case SHOLD: 
			case SKEEP: 
				arg_option = cp - 1;
				*(cp - 1) = FHOLD;
				break;
				/* jump to calling setsfd() below */
			case FNCYLS: /* # cylinders */
				rt = TRUE;
			/* no break */
			case FPROT: /* protection */
			case FSR: /* sampling rate */
			case FNC: /* # channels */
				flt = sfexpr (arg_option, 1.0);
				(void) sprintf (expstr, "%f", flt);
				sfd = setsfd (sfd, cp - 1, expstr);
				continue;
				/* skip calling setsfd() below */
			case 'i': /* ipack */
				*ipak = *arg_option;
				/* either 'f' or 's', we hope */
				continue;/* skip calling setsfd below */
			case 'o': /* opack */
				*(cp - 1) = 'P';
				/* 'P' for file packing */
				break;
			case FREM: /* Remark */
			case FINC: /* Include */
				break;
			case FRTFLAG: /* realtime */
				rt = TRUE;
				continue;
			default: 
			case EOF: 
				/* crack returns this on unknown flag */
			case 'h': /* print help message */
				(*usage) ();
				return (NULL);
			case 'b': 
				/* begin expressed as time in seconds or
				   samples */
				begsav = arg_option;
				timeset++;
				continue;/* skip calling setsfd below */
			case 'e': /* end expressed as time in seconds or
				   samples */
			case 'd': /* duration */
				endsav = arg_option;
				timeset++;
				continue;/* skip calling setsfd below */
			case FTCYLS: 
				/* cylinders needed expressed as time */
				timsav = arg_option;
				continue;/* skip calling setsfd below */
			case 'F': 
				*(omode + 2) = ch;
				/* flush sfd on each call to sndo() */
				continue;/* skip calling setsfd below */
		}
		sfd = setsfd (sfd, cp - 1, arg_option);
	}

 /* more commands to snarf, no -b or -e flags */
	if (
	    (
		argc - 2 >= arg_index
	    ) && (
		index (sfoflags, 'b') == NULL
		    || index (sfoflags, 'e') == NULL
		    || index (sfoflags, 'd') == NULL
	    )
	) {
		begsav = argv[arg_index++];
		endsav = argv[arg_index++];
		timeset++;
	}

 /* get file name */
	if (argc > arg_index) {
		name = argv[arg_index++];
	}
	else {			/* fill in default name */
		name = &defnam[1];/* skip initial slash */
	}

	if ((name = getsfn (name, NULL)) == NULL) {
		fprintf (stderr, "sfoargs: getsfile failed on %s\n",
				argv[arg_index - 1]);
		return (NULL);
	}
	sfd = setsfd (sfd, "f", name);
	*cp++ = 'f';
	*cp = NULL;

	/* fill in remaining unknowns from defaults */
	sfd = dfltsfd (sfd, sfoflags, deflags, defargs);

	/* now that we know sr and nc, figure out ncyls, begin and end */
	samplesecond = sfd -> sr * sfd -> nc;

	if (index (sfoflags, 'T') != NULL) {
		/* get result in seconds for setsfd */
		sfs = dirinfo (sfd -> sfn);
		if (sfs == NULL) {
			fprintf (stderr, 
			    "sopensf: dirinfo failed on %s\n", 
			    sfd -> sfn);
			return (NULL);
		}
		sfd -> bufsiz = sfs -> bsize;
		sfd -> blksiz = sfs -> bpblock;
		flt = sfexpr (timsav, samplesecond) / samplesecond;
		(void) sprintf (expstr, "%f", flt);
		sfd = setsfd (sfd, "T", expstr);
		rt = TRUE;
	}

 /* 
  * Set whether file is contiguous or not; sometimes called "realtime". 
  * File is contiguous if either -C or -T flags are used, or if flag
  * -tr is given.  File is made non-contiguous by default, i.e.,
  * if none of these flags appear.
  */
	sfd = setsfd (sfd, "t", rt == TRUE ? "r" : "n");

	if (!openit)
		return (sfd);	/* used by opensf, the program */

 /* using -b, -e or -d implies modifying the file */
	if (timeset)
		*(omode + 1) = 'r';/* set read-write mode */
	sfd = sopensf ((char *) NULL, omode, sfd);/* open it up */
	if (sfd -> err != 0) {
		fprintf (stderr, "%s: sound file open failed\n", argv[0]);
		exit (1);
	}

 /* sr and nc may have changed as a result of the opensf() */
	samplesecond = sfd -> sr * sfd -> nc;

	if (timeset) {
		if (*begsav == '$')
			begin = (double) sfd -> fs;
		else
			begin = sfexpr (begsav, samplesecond);
		end = sfexpr (endsav, samplesecond);
	}

 /* is end time to be taken as duration? */
	if (index (sfoflags, 'd') != NULL)
		end += begin;

 /* no end set, so make it positive infinity */
 /* thus, end of file will be determined only by EOF, not endsamp */

 /* adjust times to the nearest sample frame boundary */
	*stsamp = begin;
	if (end < 0)
		*endsamp = (unsigned) - 1 >> 1;
				/* positive long int infinity */
	else
		*endsamp = end;
	*stsamp = *stsamp - (*stsamp % sfd -> nc);
	*endsamp = *endsamp - (*endsamp % sfd -> nc);
	return (sfd);
}
