/* pidexists.c	1.1	(CARL)	7/25/84	13:43:42 */
/*
 * pidexists - search /dev/kmem process table to see if a process is still 
 * alive.
 * This routine is invoked by lock() whenever it wants to know whether the
 * process whose process id is currently in the SFLOCK file still exists, and
 * hence whether the lock is still valid.
 * Note: there are two versions of this subroutine, one for
 * 4.1 BSD and one for pre-4.1 BSD.  The difference is that beginning with
 * 4.1 BSD, the proc table is dynamic.
 */

#include <sys/param.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/proc.h>
#include <nlist.h>
#include <stdio.h>
#include <carl/sndio.h>
extern char *malloc(), *calloc(), *realloc();

#ifdef SFBSD
struct proc    *proc;
struct nlist    nl[] = {
	{
		"_proc"
	},
	{
		"_nproc"
	},
	{
		0
	},
};

pidexists (pid)
	int     pid;
{
	extern long lseek();
	register struct proc   *pp,
	                       *pend;
	int     nproc;
	long    addr;
	int     mem;

	mem = open ("/dev/kmem", 0);
	if (mem < 0) {
		perror ("/dev/kmem");
		return (-1);
	}
	nlist ("/vmunix", nl);
	if ((addr = nl[1].n_value) == 0) {
		fprintf (stderr, "/vmunix: _nproc not in namelist");
		return (-1);
	}
	if (lseek (mem, addr, 0) == -1) {
		perror("lseek");
		fprintf(stderr, "mem=%d, addr=%x\n", mem, addr);
		return(-1);
	}
	if (read (mem, (char *) &nproc, sizeof nproc) != sizeof nproc) {
		perror("read");
		return(-1);
	}
	proc = (struct proc    *) calloc ((unsigned) nproc, 
		(unsigned) sizeof *proc);
	addr = nl[0].n_value;
	if (addr == 0) {
		fprintf (stderr, "/vmunix: _proc not in namelist");
		return (-1);
	}
	if (lseek (mem, addr, 0) == -1) {
		perror("lseek");
		return(-1);
	}
	if (read (mem, (char *) &addr, sizeof addr) != sizeof addr) {
		perror("read");
		return(-1);
	}
	if (lseek (mem, addr, 0) == -1) {
		perror("lseek");
		return(-1);
	}
	if (read (mem, (char *) proc, nproc * (sizeof *proc)) 
	    != nproc * (sizeof *proc)) {
		perror("read");
		return(-1);
	}
	pend = proc + nproc;
	for (pp = proc; pp < pend; pp++) {
		if (pp -> p_pid == pid)
			break;
	}
	(void) close (mem);
	if (pp >= pend)
		return (1);	/* process not found */
	return (0);		/* process found */
}
#else
struct proc     proc[NPROC];
struct nlist    nl[] = {
	{
		"_proc"
	}, {
		0
	}, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

pidexists (pid)
int     pid;
{
	register struct proc   *pp;
	int     addr,
	        mem;

	mem = open ("/dev/kmem", 0);
	if (mem < 0) {
		perror ("/dev/kmem");
		return (-1);
	}
	nlist ("/vmunix", nl);
	addr = nl[0].n_value;
	if (addr == 0)
		return (-1);
	if (lseek (mem, addr, 0) == -1)
		perror ("lseek");
	if (read (mem, &proc[0], sizeof proc) != sizeof proc) {
		perror("read");
		return(-1);
	}
	for (pp = &proc[0]; pp < &proc[NPROC]; pp++)
		if (pp -> p_pid == pid)
			break;
	(void) close (mem);
	if (pp >= &proc[NPROC])
		return (1);	/* not found */
	return (0);		/* found */
}
#endif SFBSD

/*
 * main(argc, argv)
 * 	char **argv;
 * {
 * 
 * 	if (argc != 2) {
 * 		fprintf(stderr, "usage: pidexists pid\n");
 * 		exit(1);
 * 	}
 * 
 * 	if (!pidexists(atoi(argv[1])))
 * 		printf("%s exists\n", argv[1]);
 * 	else
 * 		printf("%s doesn't exist\n", argv[1]);
 * 	}
 */
