/* mlock.c	1.3	(CARL)	4/25/85	15:23:32 */
#include <stdio.h>
#include <sys/file.h>
#include <carl/libsf.h>
extern char *malloc(), *calloc(), *realloc();

/*
 * mlock - masterlock sound file system.  Use of this allows an equivalent
 * to single user mode for unix, and also provides a way to halt all sound
 * i/o when a particularly disasterous event occurrs.  The routines mlock()
 * and munlock() manage the file MASTERLOCK, which, when it exists, causes
 * all regular calls to lock() to fail, unless the user is a SUPERGROUPie,
 * or unless the process calls lock() with FORCE!=0.  Closesf() calls lock()
 * with FORCE so as to allow all i/o to terminate before being masterlocked.
 * Once masterlocked, lock() prints the string message in the MASTERLOCK
 * file which can be either a notice from the SUPERUSER that the system is
 * down (done by running the program locksf), or an error generated by
 * a sound file program and reported as fatal.  The system will
 * continue to disallow all i/o until the MASTERLOCK file is 
 * removed by munlock(), or the running of the program unlocksf by a
 * SUPERGROUPie.
 */

extern  FILE * lockfopen ();

mlock (fs, msg, err)
char   *fs,
       *msg;
int     err;
{
	FILE * lockfopen (), *fd;
	char   *masterlock,
	       *getsfile ();
	if (err || (ingroup (SUPERGROUP) == 1)) {
		setsfile (fs);
		masterlock = getsfile (MASTERLOCK);
		(void) umask (0);	/* let all write it who succeed this far */
		if ((fd = lockfopen (masterlock, "w")) == NULL) {
			fprintf(stderr, "mlock: lockfopen of %s failed\n",
				masterlock);
			return(-1);
		}
		fprintf (fd, "%s\n", msg);
		if (fclose (fd) != 0) {
			perror ("fclose");
			return(-1);
		}
		free (masterlock);
	}
	else {
		printf ("mlock: Sorry.\n");
		return (1);
	}
	return (0);
}

munlock (fs)
char   *fs;
{
	char   *masterlock,
	       *getsfile ();
	if (ingroup (SUPERGROUP) == 1) {
		setsfile (fs);
		masterlock = getsfile (MASTERLOCK);
		if (access (masterlock, F_OK) == 0)
			if (unlink (masterlock)) {
				perror("unlink");
				fprintf (stderr, "munlock: can't unlock %s\n", 
					masterlock);
				return (-1);
			}
		free (masterlock);
	}
	else
		printf ("munlock: Sorry.\n");
	return (0);
}


/*
 * ismlocked - tests whether the system is masterlocked or not.
 * returns 0 for not locked, -1 for locked and requestor is
 * not in superuser group,
 * 1 for locked and requestor is in superuser group.
 */

ismlocked (fs)
char   *fs;
{
	char   *masterlock,
	       *getsfile ();

	setsfile (fs);
	masterlock = getsfile (MASTERLOCK);

	if (!access (masterlock, 0)) {/* masterlock file exists */
		if (ingroup (SUPERGROUP) == 1)/* are we superusers? */
			return (1);/* yes, but say it is mlocked */
		else		/* just regular guys */
			return (-1);/* say it is unavailable */
	}
	return (0);
}


/*
 * getmlokmsg - returns first line of masterlock file, returns NULL if
 * file not there, unopenable, or unreadable, else returns the text up
 * to the first '\n' or 256 characters. 
 * User must free the string returned when done.
 */

char   *getmlokmsg (fs)
char   *fs;
{
	FILE * fopen (), *fd;
	char   *msg,
	       *masterlock,
	       *getsfile ();

	setsfile (fs);
	masterlock = getsfile (MASTERLOCK);
	if ((fd = fopen (masterlock, "r")) == NULL)
		return (NULL);
	if ((msg = (char *) malloc (256)) == NULL)
		return (NULL);
	if (fgets (msg, 256, fd) != NULL)
		return (NULL);
	if (fclose (fd) < 0)
		perror ("fclose");
	return (msg);
}
