/* ingroup.c	1.1	(CARL)	7/25/84	13:43:01 */
#include <stdio.h>
#include <grp.h>
#include <pwd.h>

/*
 * ingroup - returns 1 if user is in group, 0 if not, -1 otherwise.
 */

ingroup (group)
char   *group;
{
	extern char *strcpy();
	extern struct group   *getgrnam ();
	register struct group  *gid;
	extern char   *getprown ();
	char   *pr;
	register char  *grpusr;
	char    user[64];

	if (getuid () == 0)	/* its root */
		return (1);
	if (geteuid () == 0)	/* running in root's name */
		return (1);

	if ((gid = getgrnam (group)) == NULL) {
		fprintf (stderr, "getgrnam failed on \"%s\"\n", group);
		return (-1);
	}
	if ((pr = getprown ()) == NULL)
		return (-1);
	(void) strcpy (user, pr);

	for (grpusr = *gid->gr_mem++; grpusr != NULL; grpusr = *gid->gr_mem++)
		if (strcmp (grpusr, user) == 0)
			return (1);
	return (0);
}
