/* fsndi.c	1.1	(CARL)	7/25/84	13:42:25 */
#include <stdio.h>
#include <carl/libsf.h>

/*
 * Read one sample at location sample,  from file open on sfd,
 * return it as a float.
 */

extern int      sferror;

float   fsndi (sfd, sample)
	struct sndesc  *sfd;
	long    sample;
{
	register long	block;
	extern	long    filsfb ();

	if (sample >= sfd -> fs || sample < 0) {
		sferror = -1;
		return (0);
	}

	if (sfd -> sb == NULL && sfd -> fb == NULL) {/* get buffer */
		if (getsfbuf (sfd)) {
			sferror = -1;
			return (0);
		}
	}

	block = sample / sfd -> nsib;/* fill buffer */
	if (block != sfd -> secptr) {
		if ((sfd -> secptr = filsfb (sfd, block)) < 0) {
			sferror = SFBNDER;
			return (0);
		}
	}

	sample %= sfd -> nsib;	/* get samp in buf */
	sfd -> bdir = SFREAD;
	if (sfd -> pm == PM16BIT)
		return (*(sfd -> sb + sample) / 32767.0);
	else
		return (*(sfd -> fb + sample));
}

/* extern int sferror; */

/*
 * main(argc, argv)
 * 	int argc; char **argv;
 * {
 * 	struct sndesc *sfd, *sopensf();
 * 	float fsndi();
 * 	register int i, otty = isatty(1);
 * 	float x;
 * 
 * 	if (argc < 2) exit(1);
 * 
 * 	sfsetiname(argv[0]);
 * 
 * 	if ((sfd = sopensf(argv[1], "r", NULL)) == NULL)
 * 		{
 * 		fprintf(stderr, "fsndi: error opening file %s\n", argv[1]);
 * 		exit(-1);
 * 		}
 * 	
 * 	for (i = 0; i < sfd->fs; i++)
 * 		{
 * 		x = fsndi(sfd, i);
 * 		if (sferror) 
 * 			{ 
 * 			fprintf(stderr, "fsndi error\n");
 * 			break; 
 * 			}
 * 		if (otty) printf("%d\t%f\n", i, x);
 * 		else putfloat(&x);
 * 		}
 * 	
 * 	flushfloat();
 * 	sclosesf(sfd);
 * 	exit(0);
 * 	}
 */
