/* catchall.c	1.3	(CARL)	1/9/85	23:33:52 */
#include <signal.h>

/*
 * catchall - forward interrupts to the routine in intfunc
 * Note, SIGINT is handled specially.
 * A call to ignall() preceeds calling catchall().
 * Ignall always sets intstat to whatever value SIGINT had before
 * being set to SIGIGN.  So:
 * 1) if the process is running in the background, ignall() sets SIGINT
 * to SIGIGN, and sets intstat to SIGIGN as well, so catchall() will 
 * cause it to remain as SIGIGN.
 * 2) if the process is running in the foreground, ignall() sets SIGINT
 * to SIGIGN, and sets intstat to SIG_DFL, so catchall() will 
 * set SIGINT to intfunc.
 */


int     (*intstat) ();	/* published to ignall() */

catchall (intfunc)
	int     (*intfunc) ();
{
	if (intstat == SIG_DFL)
		(void) signal (SIGINT, intfunc);
	else
		(void) signal (SIGINT, intstat);
	(void) signal (SIGHUP, intfunc);
	(void) signal (SIGQUIT, intfunc);
	(void) signal (SIGILL, intfunc);
	(void) signal (SIGTRAP, intfunc);
	(void) signal (SIGIOT, intfunc);
	(void) signal (SIGEMT, intfunc);
	(void) signal (SIGFPE, intfunc);
#ifdef 	NOTDEF
	/* attempt to catch SIGKILL produces EINVAL */
	(void) signal (SIGKILL, intfunc);
#endif 	NOTDEF
	(void) signal (SIGBUS, intfunc);
	(void) signal (SIGSEGV, intfunc);
	(void) signal (SIGSYS, intfunc);
	(void) signal (SIGPIPE, intfunc);
/* skip SIGALRM */
	(void) signal (SIGTERM, intfunc);
#ifdef	SIGSTOP	
#ifdef 	NOTDEF
	/* attempt to catch SIGSTOP produces EINVAL */
	(void) signal (SIGSTOP, SIG_DFL);
#endif 	NOTDEF
#endif	SIGSTOP
#ifdef	SIGTSTP 
	(void) signal (SIGTSTP, SIG_DFL);
#endif
#ifdef	SIGCONT 
	(void) signal (SIGCONT, SIG_DFL);
#endif
#ifdef	SIGCHLD 
	(void) signal (SIGCHLD, SIG_DFL);
#endif
#ifdef	SIGTTIN 
	(void) signal (SIGTTIN, SIG_DFL);
#endif
#ifdef	SIGTTOU 
	(void) signal (SIGTTOU, SIG_DFL);
#endif
#ifdef  SIGTINT 
	(void) signal (SIGTINT, SIG_DFL);
#endif
#ifdef	SIGXCPU	
	(void) signal (SIGXCPU, SIG_DFL);
#endif
#ifdef	SIGXFSZ 
	(void) signal (SIGXFSZ, SIG_DFL);
#endif
}
